/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.Conjunctions;
import com.fabriziopolo.textcraft.nlg.IndependentClausesWithConjunction;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.SingleClauseSentence;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.states.ValueWithCauseState;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeState;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeStateChangeManager;
import java.util.Arrays;
import java.util.List;

public class SleepCommand
implements Command {
    private static final List<String> SLEEP_SYNONYMS = Arrays.asList("sleep", "sl");

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0) {
            return null;
        }
        if (!SLEEP_SYNONYMS.contains(words[0].toLowerCase())) {
            return null;
        }
        if (words.length > 1) {
            return ActionsAndHints.hint(this.getHelpString());
        }
        return ActionsAndHints.action(new SleepAction(context));
    }

    @Override
    public String getHelpString() {
        return "Type 'sleep' to rest for a while and recover energy.  Extreme heat or cold, rain or injury may prevent you from sleeping.  Otherwise, you can sleep at night or during the day if you're sufficiently tired.";
    }

    @Override
    public String getNameString() {
        return "sleep";
    }

    @Override
    public String getPurposeString() {
        return "Go to sleep to restore energy. (sl)";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    public static final class SleepAction
    implements UserAction {
        private final Command.Context context;

        public SleepAction(Command.Context context) {
            this.context = context;
        }

        @Override
        public String getDescription() {
            return "to go to sleep";
        }

        @Override
        public void execute(TextAppController controller) {
            ValueWithCauseState.ValueWithCause<Boolean> resultAwakeState = AwakeStateChangeManager.getChange(this.context.player, false, false, this.context.simulation.getCurrentFrame());
            if (resultAwakeState == null || !((Boolean)resultAwakeState.value).booleanValue()) {
                AwakeState.requestSleep(this.context.player, this.context.simulation);
            } else if (resultAwakeState.causeDescription != null) {
                PlayerNotificationEvent.postAlwaysPerceivable(new SingleClauseSentence(IndependentClausesWithConjunction.create(Nlg.literalClause("you cannot sleep"), Conjunctions.because, resultAwakeState.causeDescription)).toString(), this.context);
            } else {
                PlayerNotificationEvent.postAlwaysPerceivable("You can only sleep when you are exhausted or it is night.", this.context);
            }
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

