/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.wearabililty.WearabilityState;
import com.fabriziopolo.textcraft.states.wearabililty.WearableCategory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RemoveCommand
implements Command {
    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0 || !words[0].toLowerCase().equals("remove")) {
            return null;
        }
        if (words.length == 1) {
            return ActionsAndHints.hint(this.getHelpString());
        }
        Frame frame = context.simulation.getCurrentFrame();
        Map<WearableCategory, Noun> wornItemsMap = InventoryState.getWornItemsMap(context.player, frame);
        if (wornItemsMap == null) {
            return this.failWithBadObjectHint();
        }
        Collection<Noun> wornItems = wornItemsMap.values();
        List results = AbstractCommand.matchOne(words, 1, wornItems, context.player, frame).stream().filter(result -> result.getStartIndex() + result.getNumWordsMatched() == words.length).collect(Collectors.toList());
        if (results.isEmpty()) {
            return this.failWithBadObjectHint();
        }
        return new ActionsAndHints(results.stream().map(tmResult -> new Result((Noun)tmResult.data, context)).collect(Collectors.toList()));
    }

    @Override
    public String getHelpString() {
        return "Type 'remove' followed by the name of a piece of clothing you want to take off.  For instance 'remove hat'.";
    }

    @Override
    public String getNameString() {
        return "remove";
    }

    @Override
    public String getPurposeString() {
        return "Remove a piece of clothing.";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private ActionsAndHints failWithBadObjectHint() {
        return ActionsAndHints.hint("I don't recognize the item you're trying to remove.");
    }

    public static final class Result
    implements UserAction {
        private final Noun thingToRemove;
        private final Command.Context context;

        public Result(Noun thingToRemove, Command.Context context) {
            this.thingToRemove = thingToRemove;
            this.context = context;
        }

        @Override
        public String getDescription() {
            return "to remove " + NounPhraseWithArticle.a(this.thingToRemove.getContextFreeDescription());
        }

        @Override
        public void execute(TextAppController controller) {
            Frame frame = this.context.simulation.getCurrentFrame();
            WearableCategory category = WearabilityState.get(frame).getWearableCategory(this.thingToRemove);
            if (category == null) {
                PlayerNotificationEvent.postAlwaysPerceivable("You can't remove that.", this.context);
                return;
            }
            PlayerNotificationEvent.postAlwaysPerceivable("You remove " + NounPhraseWithArticle.the(this.thingToRemove.getDefaultPerception(frame)) + ".", this.context);
            InventoryState.requestRemoveWearable(this.context.player, this.thingToRemove, this.context.simulation);
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

