/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.app.menu.MainGameMenuBuilder;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import java.util.function.Supplier;

public class MenuCommand
implements Command {
    private final Supplier<SinglePlayerGameState> gameStateSupplier;

    public MenuCommand(Supplier<SinglePlayerGameState> gameStateSupplier) {
        this.gameStateSupplier = gameStateSupplier;
    }

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0) {
            return null;
        }
        String commandWord = words[0];
        if (!commandWord.equals("menu") && !commandWord.equals("m")) {
            return null;
        }
        if (words.length > 1) {
            return ActionsAndHints.hint(this.getHelpString());
        }
        return ActionsAndHints.action(new LaunchMenu(this.gameStateSupplier));
    }

    @Override
    public String getHelpString() {
        return "Go to the main menu to save/load etc.";
    }

    @Override
    public String getNameString() {
        return "menu";
    }

    @Override
    public String getPurposeString() {
        return "Go to the main menu to save/load etc. (m)";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private static final class LaunchMenu
    implements UserAction {
        private final Supplier<SinglePlayerGameState> gameStateSupplier;

        private LaunchMenu(Supplier<SinglePlayerGameState> gameStateSupplier) {
            this.gameStateSupplier = gameStateSupplier;
        }

        @Override
        public String getDescription() {
            return "to show the main menu";
        }

        @Override
        public void execute(TextAppController controller) {
            controller.getParserExecutor().launchMenu(new MainGameMenuBuilder(controller, this.gameStateSupplier).build());
        }
    }
}

