/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textcraft.commands.AbstractCraftCommand;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.SingleClauseSentence;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.capability.Capability;
import com.fabriziopolo.textcraft.states.capability.ResourceState;
import com.fabriziopolo.textcraft.states.capability.ToolState;
import java.util.List;

public abstract class DefaultCraftingDelegateImpl
implements AbstractCraftCommand.CraftingDelegate {
    private final Noun prototype;
    private final List<Capability> resourceRequirements;
    private final Capability toolRequirement;
    private final String craftingVerb;

    public List<Capability> getResourceRequirements() {
        return this.resourceRequirements;
    }

    public Capability getToolRequirement() {
        return this.toolRequirement;
    }

    protected DefaultCraftingDelegateImpl(Noun prototype, List<Capability> resourceRequirements, String craftingVerb) {
        this(prototype, resourceRequirements, null, craftingVerb);
    }

    protected DefaultCraftingDelegateImpl(Noun prototype, List<Capability> resourceRequirements, Capability toolRequirement, String craftingVerb) {
        this.prototype = prototype;
        this.resourceRequirements = resourceRequirements;
        this.toolRequirement = toolRequirement;
        this.craftingVerb = craftingVerb;
    }

    @Override
    public abstract String getHint();

    @Override
    public Noun getPrototype() {
        return this.prototype;
    }

    @Override
    public abstract Noun craftNewNoun(AbstractCraftCommand.ParseResult var1);

    @Override
    public Noun validateAndCraftNewNoun(AbstractCraftCommand.ParseResult result) {
        List<Noun> resources = result.resources;
        Simulation simulation = result.context.simulation;
        Frame frame = simulation.getCurrentFrame();
        if (this.toolRequirement == null) {
            // empty if block
        }
        int numResourcesRequired = this.resourceRequirements.size();
        if (resources.size() < numResourcesRequired) {
            PlayerNotificationEvent.postAlwaysPerceivable("That's not enough resources.  You need " + numResourcesRequired + ".  " + this.getHint(), result.context);
            return null;
        }
        if (resources.size() > numResourcesRequired) {
            PlayerNotificationEvent.postAlwaysPerceivable("That's too many resources.  " + this.getHint(), result.context);
            return null;
        }
        boolean didMatch = true;
        for (int i = 0; i < numResourcesRequired; ++i) {
            Capability capabilityRequirement;
            Noun resource = resources.get(i);
            if (this.validateResourceRequirement(result.context, resource, capabilityRequirement = this.resourceRequirements.get(i))) continue;
            didMatch = false;
        }
        if (!didMatch) {
            return null;
        }
        if (!this.validateToolRequirement(result.context, result.tool)) {
            return null;
        }
        Noun builtNoun = this.craftNewNoun(result);
        PlayerNotificationEvent.postAlwaysPerceivable("You " + this.craftingVerb + " " + NounPhraseWithArticle.a(builtNoun.getContextFreeDescription()) + ".", result.context);
        return builtNoun;
    }

    private boolean validateResourceRequirement(Command.Context context, Noun noun, Capability capability) {
        Frame frame = context.simulation.getCurrentFrame();
        Capability.Result satisfactionResult = ResourceState.get(frame).getSatisfactionResult(noun, capability, frame);
        if (!satisfactionResult.isSatisfied) {
            this.notifyPlayerOfInsufficientResource(noun, capability, satisfactionResult.failureReason, context);
        }
        return satisfactionResult.isSatisfied;
    }

    private boolean validateToolRequirement(Command.Context context, Noun tool) {
        if (this.toolRequirement == null) {
            return true;
        }
        if (tool == null) {
            this.notifyPlayerOfRequiredTool(this.toolRequirement, context);
            return false;
        }
        Frame frame = context.simulation.getCurrentFrame();
        Capability.Result result = ToolState.get(frame).getSatisfactionResult(tool, this.toolRequirement, frame);
        if (!result.isSatisfied) {
            this.notifyPlayerOfInsufficientResource(tool, this.toolRequirement, result.failureReason, context);
            return false;
        }
        return true;
    }

    private void notifyPlayerOfInsufficientResource(Noun noun, Capability requirement, IndependentClause failureReason, Command.Context context) {
        Frame frame = context.simulation.getCurrentFrame();
        NounPhrase craftable = this.prototype.getContextFreeDescription();
        String message = NounPhraseWithArticle.a(noun.getDefaultPerception(frame)) + " is an insufficient " + requirement.getNounDescription() + " " + "to " + this.craftingVerb + " " + NounPhraseWithArticle.a(craftable);
        if (failureReason != null) {
            message = message + " because " + failureReason;
        }
        String formattedMessage = SingleClauseSentence.create(Nlg.literalClause(message)).toString();
        PlayerNotificationEvent.post(context, formattedMessage);
    }

    private void notifyPlayerOfRequiredTool(Capability toolRequirement, Command.Context context) {
        NounPhrase craftable = this.prototype.getContextFreeDescription();
        String requiredTool = toolRequirement.getNounDescription();
        String message = "To " + this.craftingVerb + " " + NounPhraseWithArticle.a(craftable) + " requires a tool that can be used as a " + requiredTool + ": " + "'craft " + craftable + " from <resources> with <tool>'.";
        String formattedMessage = Nlg.literalSentences(message).toString();
        PlayerNotificationEvent.post(context, formattedMessage);
    }
}

