/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.constants.Directions;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractVerbDirectionCommand
implements Command {
    private final List<String> verbForms;

    protected AbstractVerbDirectionCommand(String[] verbForms) {
        Objects.requireNonNull(verbForms);
        if (verbForms.length == 0) {
            throw new IllegalArgumentException("AbstractVerbDirectionCommand requires at least one verb form.");
        }
        this.verbForms = new ArrayList<String>();
        for (String verbForm : verbForms) {
            this.verbForms.add(verbForm);
        }
    }

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0 || !this.verbForms.contains(words[0].toLowerCase())) {
            return null;
        }
        Noun direction = AbstractVerbDirectionCommand.matchDirection(words, 1, context);
        if (direction == null) {
            return ActionsAndHints.hint(this.getHintForBadDirection());
        }
        return this.createMatchResult(words[0].toLowerCase(), direction, context);
    }

    public String getHintForBadDirection() {
        return "To " + this.getDisplayedVerb() + " you need to specify a direction.  " + "For instance: '" + this.getDisplayedVerb() + " north'.";
    }

    public abstract ActionsAndHints createMatchResult(String var1, Noun var2, Command.Context var3);

    private static Noun matchDirection(String[] words, int idx, Command.Context context) {
        if (idx >= words.length) {
            return null;
        }
        Frame currentFrame = context.simulation.getCurrentFrame();
        Directions directions = Directions.get(currentFrame);
        for (Noun direction : directions.getAll()) {
            TextMatcher.Result result = direction.matches(words, idx, context.player, currentFrame);
            if (!result.isMatch) continue;
            return direction;
        }
        return null;
    }

    @Override
    public abstract String getHelpString();

    private String getDisplayedVerb() {
        return this.verbForms.get(0);
    }
}

