/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app.ui;

import com.fabriziopolo.textapp.InteractiveTextUi;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.light.LightState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.sun.SunState;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffectState;

public final class WeatherUiColorChanger {
    private WeatherUiColorChanger() {
    }

    public static void updateUiColor(InteractiveTextUi ui, Noun perceiver, Frame frame) {
        Boolean isRainingOnPlayer = RainEffectState.isRainingOn(perceiver, frame);
        Boolean isRainingInRoom = RainEffectState.isRainingOn(PositionState.get(frame).getContainingRoom(perceiver), frame);
        if (SunState.isPitchBlack(frame)) {
            if (LightState.getBrightnessAt(perceiver, frame) <= 0.2) {
                if (isRainingOnPlayer.booleanValue()) {
                    ui.setBackgroundColor(0.0, 0.0, 50.0);
                    ui.setForegroundColor(0.0, 255.0, 0.0);
                } else {
                    ui.setBackgroundColor(0.0, 0.0, 0.0);
                    ui.setForegroundColor(0.0, 255.0, 0.0);
                }
            } else if (isRainingOnPlayer.booleanValue()) {
                ui.setBackgroundColor(30.0, 30.0, 80.0);
                ui.setForegroundColor(0.0, 255.0, 0.0);
            } else {
                ui.setBackgroundColor(150.0, 60.0, 40.0);
                ui.setForegroundColor(0.0, 255.0, 0.0);
            }
        } else if (isRainingInRoom.booleanValue()) {
            ui.setBackgroundColor(195.0, 215.0, 255.0);
            ui.setForegroundColor(0.0, 0.0, 0.0);
        } else {
            ui.setBackgroundColor(255.0, 220.0, 200.0);
            ui.setForegroundColor(0.0, 0.0, 0.0);
        }
    }
}

