/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app;

import com.fabriziopolo.textapp.TextListener;
import com.fabriziopolo.textcraft.app.TextPrinter;
import com.fabriziopolo.textcraft.text.Text;
import java.io.PrintWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.plexus.util.StringUtils;

public class TextPrinterImpl
implements TextPrinter {
    private final boolean printToStdOut = false;
    private final AtomicBoolean isCursorToDelete = new AtomicBoolean(false);
    private PrintWriter persistentLog;
    private final int startColumn;
    private final int endColumn;
    private TextListener textListener;

    public TextPrinterImpl(int startColumn, int endColumn, PrintWriter persistentLog) {
        this.startColumn = startColumn;
        this.endColumn = endColumn;
        this.persistentLog = persistentLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String string) {
        this.log(string);
        string = string + "\n";
        this.deleteCursor();
        TextPrinterImpl textPrinterImpl = this;
        synchronized (textPrinterImpl) {
            String wrappedString = Text.wrap(this.startColumn, this.endColumn, string);
            this.printToStdOut(wrappedString);
            if (this.textListener != null) {
                this.textListener.onText(wrappedString);
            }
        }
        this.isCursorToDelete.set(false);
        this.printCursor();
    }

    @Override
    public void println() {
        this.println("");
    }

    @Override
    public void printCursor() {
        if (!this.isCursorToDelete.get()) {
            this.printToStdOut(">");
            this.isCursorToDelete.set(true);
        }
    }

    @Override
    public void deleteCursor() {
        if (this.isCursorToDelete.get()) {
            this.printToStdOut("\b");
            this.isCursorToDelete.set(false);
        }
    }

    @Override
    public void log(String string) {
        if (this.persistentLog == null) {
            return;
        }
        ZonedDateTime now = ZonedDateTime.ofInstant(Instant.now(), ZoneId.systemDefault());
        this.persistentLog.println(DateTimeFormatter.ofPattern("hh:mm:ss").format(now) + " " + string);
    }

    @Override
    public void logInput(String inputString) {
        this.println();
        this.println(StringUtils.repeat("-", this.endColumn - this.startColumn - 1));
        this.println("> " + inputString);
    }

    @Override
    public void closeLog() {
        if (this.persistentLog != null) {
            this.persistentLog.close();
            this.persistentLog = null;
        }
    }

    @Override
    public void setTextListener(TextListener textListener) {
        this.textListener = textListener;
    }

    private void printToStdOut(String string) {
    }
}

