/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.SinglePlayerSimulation;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeState;
import com.fabriziopolo.textcraft.states.singleplayer.PauseGameState;
import com.fabriziopolo.textcraft.states.singleplayer.WaitState;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class SimulationPlayer {
    private final Object interactionLock = new Object();
    private final SinglePlayerSimulation simulation;
    private Thread simulationThread = null;
    private AtomicBoolean running = new AtomicBoolean(true);
    private AtomicBoolean advance = new AtomicBoolean(false);
    private AtomicBoolean isFirstPlay = new AtomicBoolean(true);
    private final BiFunction<SinglePlayerSimulation, Frame, Boolean> onFrame;

    public SimulationPlayer(SinglePlayerSimulation simulation, BiFunction<SinglePlayerSimulation, Frame, Boolean> onFrame) {
        this.simulation = Objects.requireNonNull(simulation);
        this.onFrame = Objects.requireNonNull(onFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        Object object = this.interactionLock;
        synchronized (object) {
            if (this.simulationThread == null || !this.simulationThread.isAlive()) {
                this.running.set(true);
                this.simulationThread = new Thread(this::playLoop);
                this.simulationThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.interactionLock;
        synchronized (object) {
            this.running.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.interactionLock;
        synchronized (object) {
            this.running.set(false);
            this.simulationThread = null;
        }
    }

    public void advance() {
        this.advance.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Consumer<Simulation> doMe) {
        Object object = this.interactionLock;
        synchronized (object) {
            doMe.accept(this.simulation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SinglePlayerSimulation getSimulation() {
        Object object = this.interactionLock;
        synchronized (object) {
            return this.simulation;
        }
    }

    public boolean isPlaying() {
        return this.running.get();
    }

    private void playLoop() {
        Frame prevFrame = this.simulation.getCurrentFrame();
        if (this.isFirstPlay.get()) {
            this.isFirstPlay.set(false);
            boolean bl = this.onFrame.apply(this.simulation, prevFrame);
        }
        while (this.running.get()) {
            Instant startTime = Instant.now();
            prevFrame = this.simulation.getCurrentFrame();
            this.simulation.update();
            Instant endTime = Instant.now();
            boolean gameOver = this.onFrame.apply(this.simulation, prevFrame);
            this.waitForNextFrameIfNecessary();
            if (!gameOver && !PauseGameState.isGamePaused(this.simulation.getCurrentFrame())) continue;
            this.running.set(false);
            return;
        }
    }

    private void waitForNextFrameIfNecessary() {
        Frame frame = this.simulation.getCurrentFrame();
        Boolean isAwake = AwakeState.get(frame).isAwake(this.simulation.player);
        if (isAwake != null && !isAwake.booleanValue()) {
            return;
        }
        if (WaitState.get(frame).isWaiting(this.simulation.player)) {
            return;
        }
        try {
            this.waitForNextFrameOrAdvance(this.simulation.getUpdateParameters().getPlayTimeDtSeconds());
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    private void waitForNextFrameOrAdvance(double seconds) throws InterruptedException {
        for (int i = 0; i < (int)(100.0 * seconds); ++i) {
            if (this.advance.get()) {
                this.advance.set(false);
                return;
            }
            Thread.sleep(10L);
        }
    }
}

