/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.GuiLib;

import GuiTool.GuiLib.GridBag;
import GuiTool.GuiLib.LibCloseableFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class LvgHtmlBrowser
extends JDialog
implements ActionListener {
    private JEditorPane htmlPane_ = null;
    private JScrollPane scrollPane_ = null;
    private JPanel mainPane_ = null;
    private JButton backB_ = new JButton("Back");
    private JButton forwardB_ = new JButton("Forward");
    private JButton reloadB_ = new JButton("Reload");
    private JButton homeB_ = new JButton("Home");
    private JButton closeB_ = new JButton("Close");
    private LinkedList<String> urlHistory_ = new LinkedList();
    private int urlIndex_ = -1;
    private String homeUrl_ = null;
    private static final long serialVersionUID = 5L;

    public LvgHtmlBrowser(JFrame owner, String title, String url) {
        super(owner, title, true);
        this.setLocationRelativeTo(owner);
        this.setSize(500, 700);
        try {
            this.htmlPane_ = new JEditorPane(url);
            this.urlHistory_.add(url);
            ++this.urlIndex_;
            this.homeUrl_ = url;
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        this.htmlPane_.setEditable(false);
        this.scrollPane_ = new JScrollPane(this.htmlPane_);
        JPanel controlP = new JPanel();
        controlP.add(this.backB_);
        controlP.add(this.forwardB_);
        controlP.add(this.reloadB_);
        controlP.add(this.homeB_);
        controlP.add(this.closeB_);
        this.backB_.addActionListener(this);
        this.forwardB_.addActionListener(this);
        this.reloadB_.addActionListener(this);
        this.homeB_.addActionListener(this);
        this.closeB_.addActionListener(this);
        this.mainPane_ = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        this.mainPane_.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(1, 5, 1, 5);
        gbc.fill = 0;
        gbc.anchor = 11;
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        this.mainPane_.add((Component)controlP, gbc);
        gbc.weighty = 100.0;
        gbc.insets = new Insets(3, 5, 3, 5);
        gbc.fill = 1;
        gbc.anchor = 10;
        GridBag.SetPosSize(gbc, 0, 1, 1, 1);
        this.mainPane_.add((Component)this.scrollPane_, gbc);
        this.getContentPane().add(this.mainPane_);
        this.ActiveHyperLink();
    }

    public LvgHtmlBrowser(JFrame owner, String title, String home, String url) {
        this(owner, title, url);
        this.homeUrl_ = home;
    }

    public LvgHtmlBrowser(JFrame owner, String title, int width, int height, String url) {
        this(owner, title, url);
        this.setSize(width, height);
    }

    public LvgHtmlBrowser(JFrame owner, String title, int width, int height, String home, String url) {
        this(owner, title, width, height, url);
        this.homeUrl_ = home;
    }

    public void SetPage(String url) {
        this.GoToUrl(url);
        this.urlIndex_ = 0;
        this.urlHistory_.clear();
        this.urlHistory_.add(url);
    }

    public void SetHome(String home) {
        this.homeUrl_ = home;
    }

    public JEditorPane GetHtmlPane() {
        return this.htmlPane_;
    }

    public JPanel GetMainPane() {
        return this.mainPane_;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.backB_) {
            if (this.urlIndex_ > 0) {
                String url = this.urlHistory_.get(this.urlIndex_ - 1);
                this.GoToUrl(url);
                --this.urlIndex_;
            }
        } else if (source == this.forwardB_) {
            if (this.urlIndex_ + 1 < this.urlHistory_.size()) {
                String url = this.urlHistory_.get(this.urlIndex_ + 1);
                this.GoToUrl(url);
                ++this.urlIndex_;
            }
        } else if (source == this.reloadB_) {
            String url = this.urlHistory_.get(this.urlIndex_);
            this.GoToUrl(url);
        } else if (source == this.homeB_) {
            this.GoToUrl(this.homeUrl_);
            this.urlHistory_.add(this.homeUrl_);
            ++this.urlIndex_;
        } else if (source == this.closeB_) {
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        LibCloseableFrame frame = new LibCloseableFrame();
        frame.setTitle("Html Browser");
        LvgHtmlBrowser browser = new LvgHtmlBrowser(frame, "Lvg Help Document", 500, 700, "http://lexsrv3.nlm.nih.gov/LexSysGroup/Projects/lvg/current/docs/designDoc/index.html", "http://lexsrv3.nlm.nih.gov/LexSysGroup/Projects/lvg/current/docs/designDoc/flow/lowercase.html");
        browser.setVisible(true);
    }

    private void ActiveHyperLink() {
        this.htmlPane_.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent ev) {
                try {
                    if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        LvgHtmlBrowser.this.htmlPane_.setPage(ev.getURL());
                        int size = LvgHtmlBrowser.this.urlHistory_.size();
                        if (LvgHtmlBrowser.this.urlIndex_ + 1 < size) {
                            for (int i = LvgHtmlBrowser.this.urlIndex_ + 1; i < size; ++i) {
                                LvgHtmlBrowser.this.urlHistory_.removeLast();
                            }
                        }
                        LvgHtmlBrowser.this.urlIndex_++;
                        LvgHtmlBrowser.this.urlHistory_.add(ev.getURL().toString());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        });
    }

    private void GoToUrl(String url) {
        try {
            this.htmlPane_.setPage(url);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

