/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLWarning;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;

public class Util {
    static final void throwError(HsqlException hsqlException) throws SQLException {
        throw Util.sqlException(hsqlException.getMessage(), hsqlException.getSQLState(), hsqlException.getErrorCode(), hsqlException);
    }

    static final void throwError(Result result) throws SQLException {
        throw Util.sqlException(result.getMainString(), result.getSubString(), result.getErrorCode(), result.getException());
    }

    public static final SQLException sqlException(HsqlException hsqlException) {
        return Util.sqlException(hsqlException.getMessage(), hsqlException.getSQLState(), hsqlException.getErrorCode(), hsqlException);
    }

    public static final SQLException sqlException(HsqlException hsqlException, Throwable throwable) {
        return Util.sqlException(hsqlException.getMessage(), hsqlException.getSQLState(), hsqlException.getErrorCode(), throwable);
    }

    public static final SQLException sqlException(int n) {
        return Util.sqlException(Error.error(n));
    }

    public static final SQLException sqlExceptionSQL(int n) {
        return Util.sqlException(Error.error(n));
    }

    public static final SQLException sqlException(int n, String string) {
        return Util.sqlException(Error.error(n, string));
    }

    public static final SQLException sqlException(int n, String string, Exception exception) {
        return Util.sqlException(Error.error(n, string), exception);
    }

    public static final SQLException sqlException(int n, int n2) {
        return Util.sqlException(Error.error(n, n2));
    }

    static final SQLException sqlException(int n, int n2, Object[] objectArray) {
        return Util.sqlException(Error.error(null, n, n2, objectArray));
    }

    static final SQLException notSupported() {
        return Util.sqlException(Error.error(1500));
    }

    static SQLException notUpdatableColumn() {
        return Util.sqlException(2500);
    }

    public static SQLException nullArgument() {
        return Util.sqlException(423);
    }

    static SQLException nullArgument(String string) {
        return Util.sqlException(423, string + ": null");
    }

    public static SQLException invalidArgument() {
        return Util.sqlException(423);
    }

    public static SQLException invalidArgument(String string) {
        return Util.sqlException(423, string);
    }

    public static SQLException outOfRangeArgument() {
        return Util.sqlException(423);
    }

    public static SQLException outOfRangeArgument(String string) {
        return Util.sqlException(423, string);
    }

    public static SQLException connectionClosedException() {
        return Util.sqlException(1303);
    }

    public static SQLWarning sqlWarning(Result result) {
        return new SQLWarning(result.getMainString(), result.getSubString(), result.getErrorCode());
    }

    public static SQLException sqlException(Result result) {
        return new SQLException(result.getMainString(), result.getSubString(), result.getErrorCode(), result.getException());
    }

    public static final SQLException sqlException(String string, String string2, int n, Throwable throwable) {
        if (string2.startsWith("08")) {
            if (!string2.endsWith("3")) {
                return new SQLTransientConnectionException(string, string2, n, throwable);
            }
            return new SQLNonTransientConnectionException(string, string2, n, throwable);
        }
        if (string2.startsWith("22")) {
            return new SQLDataException(string, string2, n, throwable);
        }
        if (string2.startsWith("23")) {
            return new SQLIntegrityConstraintViolationException(string, string2, n, throwable);
        }
        if (string2.startsWith("28")) {
            return new SQLInvalidAuthorizationSpecException(string, string2, n, throwable);
        }
        if (string2.startsWith("42") || string2.startsWith("37") || string2.startsWith("2A")) {
            return new SQLSyntaxErrorException(string, string2, n, throwable);
        }
        if (string2.startsWith("40")) {
            return new SQLTransactionRollbackException(string, string2, n, throwable);
        }
        if (string2.startsWith("0A")) {
            return new SQLFeatureNotSupportedException(string, string2, n, throwable);
        }
        return new SQLException(string, string2, n, throwable);
    }
}

