/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.LongKeyLongValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.ReaderInputStream;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollectionSession;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.LobData;

public class SessionData {
    private final Database database;
    private final Session session;
    PersistentStoreCollectionSession persistentStoreCollection;
    LongKeyHashMap resultMap;
    DataFileCacheSession resultCache;
    Object currentValue;
    HashMap sequenceMap;
    OrderedHashSet sequenceUpdateSet;
    LongKeyLongValueHashMap resultLobs = new LongKeyLongValueHashMap();
    boolean hasLobOps;

    public SessionData(Database database, Session session) {
        this.database = database;
        this.session = session;
        this.persistentStoreCollection = new PersistentStoreCollectionSession(session);
    }

    public PersistentStore getRowStore(TableBase tableBase) {
        if (tableBase.tableType == 1) {
            if (this.session.isAdmin()) {
                return tableBase.store;
            }
            return this.persistentStoreCollection.getStore(tableBase);
        }
        if (tableBase.store != null) {
            return tableBase.store;
        }
        if (tableBase.isSessionBased) {
            return this.persistentStoreCollection.getStore(tableBase);
        }
        return this.database.persistentStoreCollection.getStore(tableBase);
    }

    public PersistentStore getSubqueryRowStore(TableBase tableBase) {
        PersistentStore persistentStore = this.persistentStoreCollection.getStore(tableBase);
        persistentStore.removeAll();
        return persistentStore;
    }

    public PersistentStore getNewResultRowStore(TableBase tableBase, boolean bl) {
        try {
            PersistentStore persistentStore = this.session.database.logger.newStore(this.session, this.persistentStoreCollection, tableBase, bl);
            return persistentStore;
        }
        catch (HsqlException hsqlException) {
            throw Error.runtimeError(201, "SessionData");
        }
    }

    void setResultSetProperties(Result result, Result result2) {
        int n = result.rsProperties;
        int n2 = result2.rsProperties;
        if (n != n2) {
            if (ResultProperties.isReadOnly(n)) {
                n2 = ResultProperties.addHoldable(n2, ResultProperties.isHoldable(n));
            } else if (ResultProperties.isUpdatable(n2)) {
                if (ResultProperties.isHoldable(n)) {
                    this.session.addWarning(Error.error(4713));
                }
            } else {
                n2 = ResultProperties.addHoldable(n2, ResultProperties.isHoldable(n));
                this.session.addWarning(Error.error(4712));
            }
            if (ResultProperties.isSensitive(n)) {
                this.session.addWarning(Error.error(4711));
            }
            result2.rsProperties = n2 = ResultProperties.addScrollable(n2, ResultProperties.isScrollable(n));
        }
    }

    Result getDataResultHead(Result result, Result result2, boolean bl) {
        int n = result.getFetchSize();
        result2.setResultId(this.session.actionTimestamp);
        int n2 = result.rsProperties;
        int n3 = result2.rsProperties;
        if (n2 != n3) {
            n3 = ResultProperties.isReadOnly(n2) ? ResultProperties.addHoldable(n3, ResultProperties.isHoldable(n2)) : (ResultProperties.isReadOnly(n3) ? ResultProperties.addHoldable(n3, ResultProperties.isHoldable(n2)) : (this.session.isAutoCommit() ? ResultProperties.addHoldable(n3, ResultProperties.isHoldable(n2)) : ResultProperties.addHoldable(n3, false)));
            result2.rsProperties = n3 = ResultProperties.addScrollable(n3, ResultProperties.isScrollable(n2));
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (ResultProperties.isUpdatable(result2.rsProperties)) {
            bl2 = true;
        }
        if (bl) {
            if (n != 0 && result2.getNavigator().getSize() > n) {
                bl3 = true;
                bl2 = true;
            }
        } else if (!result2.getNavigator().isMemory()) {
            bl2 = true;
        }
        if (bl2) {
            if (this.resultMap == null) {
                this.resultMap = new LongKeyHashMap();
            }
            this.resultMap.put(result2.getResultId(), result2);
        }
        if (bl3) {
            result2 = Result.newDataHeadResult(this.session, result2, 0, n);
        }
        return result2;
    }

    Result getDataResultSlice(long l, int n, int n2) {
        RowSetNavigatorClient rowSetNavigatorClient = this.getRowSetSlice(l, n, n2);
        return Result.newDataRowsResult(rowSetNavigatorClient);
    }

    Result getDataResult(long l) {
        Result result = (Result)this.resultMap.get(l);
        return result;
    }

    RowSetNavigatorClient getRowSetSlice(long l, int n, int n2) {
        Result result = (Result)this.resultMap.get(l);
        RowSetNavigator rowSetNavigator = result.getNavigator();
        if (n + n2 > rowSetNavigator.getSize()) {
            n2 = rowSetNavigator.getSize() - n;
        }
        return new RowSetNavigatorClient(rowSetNavigator, n, n2);
    }

    public void closeNavigator(long l) {
        Result result = (Result)this.resultMap.remove(l);
        result.getNavigator().close();
    }

    public void closeAllNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator iterator = this.resultMap.values().iterator();
        while (iterator.hasNext()) {
            Result result = (Result)iterator.next();
            result.getNavigator().close();
        }
        this.resultMap.clear();
    }

    public void closeAllTransactionNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator iterator = this.resultMap.values().iterator();
        while (iterator.hasNext()) {
            Result result = (Result)iterator.next();
            if (ResultProperties.isHoldable(result.rsProperties)) continue;
            result.getNavigator().close();
            iterator.remove();
        }
        this.resultMap.clear();
    }

    public DataFileCacheSession getResultCache() {
        if (this.resultCache == null) {
            String string = this.database.logger.getTempDirectoryPath();
            if (string == null) {
                return null;
            }
            try {
                this.resultCache = new DataFileCacheSession(this.database, string + "/session_" + Long.toString(this.session.getId()));
                this.resultCache.open(false);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return this.resultCache;
    }

    synchronized void closeResultCache() {
        if (this.resultCache != null) {
            try {
                this.resultCache.close(false);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            this.resultCache = null;
        }
    }

    public void addToCreatedLobs(long l) {
        this.hasLobOps = true;
    }

    public void adjustLobUsageCount(Object object, int n) {
        if (this.session.isProcessingLog || this.session.isProcessingScript) {
            return;
        }
        if (object == null) {
            return;
        }
        this.database.lobManager.adjustUsageCount(((LobData)object).getId(), n);
        this.hasLobOps = true;
    }

    public void adjustLobUsageCount(TableBase tableBase, Object[] objectArray, int n) {
        if (!tableBase.hasLobColumn) {
            return;
        }
        if (this.session.isProcessingLog || this.session.isProcessingScript) {
            return;
        }
        for (int i = 0; i < tableBase.columnCount; ++i) {
            Object object;
            if (!tableBase.colTypes[i].isLobType() || (object = objectArray[i]) == null) continue;
            this.database.lobManager.adjustUsageCount(((LobData)object).getId(), n);
            this.hasLobOps = true;
        }
    }

    public void allocateLobForResult(ResultLob resultLob, InputStream inputStream) {
        long l = resultLob.getLobID();
        switch (resultLob.getSubType()) {
            case 7: {
                long l2;
                long l3 = resultLob.getBlockLength();
                if (inputStream == null) {
                    l2 = l;
                    inputStream = resultLob.getInputStream();
                } else {
                    BlobDataID blobDataID = this.session.createBlob(l3);
                    l2 = blobDataID.getId();
                    this.resultLobs.put(l, l2);
                }
                CountdownInputStream countdownInputStream = new CountdownInputStream(inputStream);
                countdownInputStream.setCount(l3);
                this.database.lobManager.setBytesForNewBlob(l2, countdownInputStream, resultLob.getBlockLength());
                break;
            }
            case 8: {
                long l4;
                long l5 = resultLob.getBlockLength();
                if (inputStream == null) {
                    l4 = l;
                    inputStream = resultLob.getReader() != null ? new ReaderInputStream(resultLob.getReader()) : resultLob.getInputStream();
                } else {
                    ClobDataID clobDataID = this.session.createClob(l5);
                    l4 = clobDataID.getId();
                    this.resultLobs.put(l, l4);
                }
                CountdownInputStream countdownInputStream = new CountdownInputStream(inputStream);
                countdownInputStream.setCount(l5 * 2L);
                this.database.lobManager.setCharsForNewClob(l4, countdownInputStream, resultLob.getBlockLength());
                break;
            }
        }
    }

    public void registerLobForResult(Result result) {
        RowSetNavigator rowSetNavigator = result.getNavigator();
        if (rowSetNavigator == null) {
            this.registerLobsForRow((Object[])result.valueData);
        } else {
            while (rowSetNavigator.next()) {
                Object[] objectArray = rowSetNavigator.getCurrent();
                this.registerLobsForRow(objectArray);
            }
            rowSetNavigator.reset();
        }
        this.resultLobs.clear();
    }

    private void registerLobsForRow(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            long l;
            LobData lobData;
            if (objectArray[i] instanceof BlobDataID) {
                lobData = (BlobDataID)objectArray[i];
                l = this.resultLobs.get(lobData.getId());
                objectArray[i] = this.database.lobManager.getBlob(l);
                continue;
            }
            if (!(objectArray[i] instanceof ClobDataID)) continue;
            lobData = (ClobDataID)objectArray[i];
            l = this.resultLobs.get(lobData.getId());
            objectArray[i] = this.database.lobManager.getClob(l);
        }
    }

    public void startRowProcessing() {
        if (this.sequenceMap != null) {
            this.sequenceMap.clear();
        }
    }

    public Object getSequenceValue(NumberSequence numberSequence) {
        HsqlNameManager.HsqlName hsqlName;
        Object object;
        if (this.sequenceMap == null) {
            this.sequenceMap = new HashMap();
            this.sequenceUpdateSet = new OrderedHashSet();
        }
        if ((object = this.sequenceMap.get(hsqlName = numberSequence.getName())) == null) {
            object = numberSequence.getValueObject();
            this.sequenceMap.put(hsqlName, object);
            this.sequenceUpdateSet.add(numberSequence);
        }
        return object;
    }
}

