/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.beach;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationProvider;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounMatchingSingularAndPlural;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Number;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.nlg.SimpleNounAutoBuilder;
import com.fabriziopolo.textcraft.objects.EmptyNoun;
import com.fabriziopolo.textcraft.objects.GroupedCollectionNoun;
import com.fabriziopolo.textcraft.objects.MultiSidedNoun;
import com.fabriziopolo.textcraft.objects.NaturalLiquidContainerNoun;
import com.fabriziopolo.textcraft.objects.NounOfContents;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.characterbio.CharacterBioEffect;
import com.fabriziopolo.textcraft.states.description.DescriptionState;
import com.fabriziopolo.textcraft.states.edibility.AddIventoryItemsEdibleEffect;
import com.fabriziopolo.textcraft.states.edibility.CharacterBioEdibleEffect;
import com.fabriziopolo.textcraft.states.edibility.EdibleEffect;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.takeable.TakeHandler;
import com.fabriziopolo.textcraft.states.takeable.TakesContentsTakeHandler;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffect;
import com.fabriziopolo.timecraft.capabilities.ResourceCapabilities;
import com.fabriziopolo.timecraft.capabilities.TokenResourceCapabilities;
import com.fabriziopolo.timecraft.tools.liquidcontainer.FillLiquidContainerRainEffect;
import com.fabriziopolo.timecraft.tools.lumberjack.TreeCuttingTakeHandler;
import com.fabriziopolo.timecraft.world.constants.Encumbrances;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import com.fabriziopolo.timecraft.world.dsl.beach.Beach;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class Plants
extends Beach {
    public static final RainEffect fillContainerRainEffect = new FillLiquidContainerRainEffect(){

        @Override
        public Noun supplyRainWater(Simulation simulation) {
            return new Dsl(simulation).beach().resources().rainWater();
        }
    };
    private static final TakeHandler dumpsContentsTakeHandler = new TakeHandler(){

        @Override
        public void doProduce(Player player, Noun originalNounToTake, List<Noun> producedNouns, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
            Frame frame = simulation.getCurrentFrame();
            Set<Noun> contents = StructureState.getNonintegralChildren(originalNounToTake, frame, partialState);
            if (!contents.isEmpty()) {
                contents.forEach(item -> partialState.disconnect((Noun)item));
                Noun content = new ArrayList<Noun>(contents).get(0);
                Noun spotToSpill = PositionState.get(frame).getParent(originalNounToTake);
                Preposition spillPreposition = PositionState.get(frame).getPreposition(originalNounToTake);
                PlayerNotificationEvent.post((Noun)player, simulation, new SpillContentsNotificationProvider(content, spotToSpill, spillPreposition));
            }
            partialState.disconnect(originalNounToTake);
        }

        @Override
        public Noun willProduceOne(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
            return nounToTake;
        }
    };

    public Plants(Simulation simulation) {
        super(simulation);
    }

    public Noun smallPalmTree() {
        SimpleNoun atTree = SimpleNoun.autoBuilder().setDescription("This small palm tree doesn't provide much shelter but there is a bit of shade underneath it.", "a small palm tree", "trees", new String[0]).setDarkDescription("The outline of this small palm tree is barely visible against the stars.", "a small barely visible tree", "trees", new String[0]).build();
        SimpleNoun upTree = SimpleNoun.autoBuilder().setDescription(Nlg.literalSentences("Fronds surround you."), atTree.getContextFreeDescription()).setDarkDescription(Nlg.literalSentences("Fronds bend in the wind tickling your face.  The grooved trunk provides reliable purchase for your bare feet."), atTree.getContextFreeDescription()).darkWhenBlind().build();
        Noun tree = this.createTree("palm", atTree, upTree);
        this.put(this.coconut(), Prepositions.up, tree);
        return tree;
    }

    public Noun createTree(String treeTypeName, Noun atTree, Noun upTree) {
        MultiSidedNoun tree = MultiSidedNoun.builder(atTree).asViewedFacing(SpacialRelationship.of(Prepositions.down), upTree).build();
        this.setTakeHandler(tree, new TreeCuttingTakeHandler(this.treeLog(treeTypeName)));
        this.makeProminent(tree);
        EmptyNoun underEntrance = new EmptyNoun();
        this.makeEntrance((Noun)tree, Prepositions.under, (Noun)underEntrance);
        Noun upEntrance = this.makeEntrance((Noun)tree, Prepositions.up);
        this.makeSurrounding(Prepositions.up, tree);
        DescriptionState.requestDescribeChildrenInOverview(tree, this.simulation);
        this.makeBlockPerception(upEntrance);
        this.makeProvidePartialShade(underEntrance, 0.7);
        this.addResourceCapability(tree, ResourceCapabilities.MINOR_VERTICAL_STRUCTURE);
        this.addResourceCapability(tree, TokenResourceCapabilities.IS_TREE);
        return tree;
    }

    public Noun smallPalmTree2() {
        SimpleNoun atTree = SimpleNoun.autoBuilder().setDescription("This small palm tree doesn't provide much shelter but there is a bit of shade underneath it.", "a small palm tree", "trees", new String[0]).setDarkDescription("The outline of this small palm tree is barely visible against the stars.", "a small barely visible tree", "trees", new String[0]).build();
        Sentences upTreeVerboseDescription = Nlg.literalSentences("Fronds surround you.");
        SimpleNoun upTree = SimpleNoun.autoBuilder().setDescription(upTreeVerboseDescription, atTree.getContextFreeDescription()).alwaysVisible().build();
        MultiSidedNoun tree = MultiSidedNoun.builder(atTree).asViewedFacing(SpacialRelationship.of(Prepositions.down), upTree).build();
        this.setTakeHandler(tree, new TreeCuttingTakeHandler(this.treeLog("palm tree")));
        this.makeProminent(tree);
        EmptyNoun underEntrance = new EmptyNoun();
        this.makeEntrance((Noun)tree, Prepositions.under, (Noun)underEntrance);
        DescriptionState.requestDescribeChildrenInOverview(tree, this.simulation);
        this.makeEntrance((Noun)tree, Prepositions.up, (Noun)new EmptyNoun());
        this.makeSurrounding(Prepositions.up, tree);
        this.makeExternallyInvisible(upTree);
        this.put(this.coconut(), Prepositions.in, tree);
        this.makeProvidePartialShade(underEntrance, 0.7);
        this.addResourceCapability(tree, ResourceCapabilities.MINOR_VERTICAL_STRUCTURE);
        this.addResourceCapability(tree, TokenResourceCapabilities.IS_TREE);
        return tree;
    }

    public Noun treeLog(String treeType) {
        SimpleNoun obj = new SimpleNounAutoBuilder().setDescription("The log from a felled " + treeType + " tree.", "a " + treeType + " tree log", "logs", new String[0]).setDarkDescription("A barely visible log.", "a barely visible log", "logs", new String[0]).build();
        this.setEncumbrance(obj, Encumbrances.MAJOR_EFFORT);
        this.addResourceCapability(obj, ResourceCapabilities.LARGE_BURNABLE_MATERIAL);
        this.addResourceCapability(obj, ResourceCapabilities.BEAM_STRUCTURE);
        return obj;
    }

    public Noun poisonBerryBush() {
        NounOfContents bush = new NounOfContents(){

            @Override
            protected Noun getDelegateBasedOnContents(Noun object, List<Noun> contents, Frame frame) {
                if (contents.isEmpty()) {
                    return new SimpleNounAutoBuilder().setDescription("A small scrubby looking bush.", "a small scrubby looking bush", "bushes", new String[0]).setDarkDescription("In the dark you can tell it's a bush and not much else.", "a bush-shaped shadow", "shadows", "a bush", "bushes").build();
                }
                if (contents.size() <= 3) {
                    GroupedCollectionNoun content = new GroupedCollectionNoun(contents);
                    return new SimpleNounAutoBuilder().setDescription("A small scrubby looking bush with " + NounPhraseWithArticle.a(content.getDefaultPerception(frame)) + " on it.", "a small scrubby looking bush", "bushes", new String[0]).setDarkDescription("In the dark you can tell it's a bush and not much else.", "a bush-shaped shadow", "shadows", "a bush", "bushes").build();
                }
                Noun content = contents.get(0);
                return new SimpleNounAutoBuilder().setDescription("A round, scrubby looking bush covered in " + content.getDefaultPerception(frame).as(Number.Plural) + ".", "a small scrubby looking berry bush", "bushes", new String[0]).setDarkDescription("In the dark you can tell it's a bush and not much else.", "a bush-shaped shadow", "shadows", "a bush", "bushes").build();
            }
        };
        for (int i = 0; i < 6; ++i) {
            this.put(this.poisonBerry(), Prepositions.on, bush);
        }
        this.makeUntakeable(bush, "That's firmly attached to the ground.");
        return bush;
    }

    public Noun poisonBerry() {
        SimpleNoun singularBerry = SimpleNoun.auto("This berry is small, hard, and round.  It looks like a miniature cranberry.", "a small red berry", "berries", new String[0]);
        NounMatchingSingularAndPlural obj = new NounMatchingSingularAndPlural(singularBerry);
        this.makePoisonousLikeBerry(obj);
        this.setEncumbrance(obj, Encumbrances.MARBLE_SIZED);
        return obj;
    }

    private void makePoisonousLikeBerry(Noun noun) {
        this.makeEdible(noun, "The berry tastes horribly bitter.  It takes all your effort to swallow it, after which you promptly throw it back up.", CharacterBioEffect.builder().addHealth(-0.3).addHydration(-0.4).build());
    }

    public Noun junglePlant() {
        SimpleNoun obj = SimpleNoun.auto("The wide leaf of this low jungle plant is shaped in such a way as to collect water and direct it to the roots.", "a wide-leafed jungle plant", "plants", "a wide plant leaf", "leaves");
        this.makeBlockRain(obj);
        this.setTakeHandler(obj, TakesContentsTakeHandler.createRemovingWhenEmpty());
        this.put(this.junglePlantLeaf(), Prepositions.on, obj);
        this.put(this.junglePlantLeaf(), Prepositions.on, obj);
        this.put(this.junglePlantLeaf(), Prepositions.on, obj);
        this.makeBlockPerception(obj);
        this.addResourceCapability(obj, TokenResourceCapabilities.IS_JUNGLE_PLANT);
        return obj;
    }

    public Noun junglePlantLeaf() {
        SimpleNoun delegate = SimpleNoun.auto("The wide leaf of this low jungle plant is shaped in such a way as to collect water and direct it to the roots.", "a wide plant leaf", "leaves", new String[0]);
        NaturalLiquidContainerNoun obj = new NaturalLiquidContainerNoun(delegate);
        this.setEncumbrance(obj, Encumbrances.LIGHT_AND_LONG);
        this.setRainEffect(obj, fillContainerRainEffect);
        this.setTakeHandler(obj, dumpsContentsTakeHandler);
        this.addResourceCapability(obj, ResourceCapabilities.MINOR_ROOF_STRUCTURE);
        this.addResourceCapability(obj, ResourceCapabilities.MINOR_FABRIC_MATERIAL);
        return obj;
    }

    public Noun coconut() {
        SimpleNoun obj = SimpleNoun.auto("You know what a coconut looks like.", "a coconut", "coconuts", new String[0]);
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        CharacterBioEffect bioEffect = CharacterBioEffect.builder().addFood(0.3).addHydration(0.3).addEnergy(0.1).build();
        Noun dropItem = this.coconutHusk();
        this.makeEdible((Noun)obj, "Tasty.", new AddIventoryItemsEdibleEffect((EdibleEffect)new CharacterBioEdibleEffect(bioEffect), dropItem));
        return obj;
    }

    public Noun coconutHusk() {
        SimpleNoun obj = SimpleNoun.auto("A coconut husk, cracked in half.", "a coconut husk", "husks", "a coconut shell", "shells");
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        this.addResourceCapability(obj, ResourceCapabilities.BRA_CUP_MATERIAL);
        return obj;
    }

    public Noun alwaysVisibleDuneGrassIntegralFeature() {
        return new SimpleNounAutoBuilder().setDescription("This variety of grass is tall with a deep root structure.  The leaves are sun-baked and extremely dry.", "dune grass", "grass bundles", new String[0]).alwaysVisible().build();
    }

    public Noun duneGrass() {
        SimpleNoun obj = SimpleNoun.auto("This variety of grass is tall with a deep root structure.  The leaves are sun-baked and extremely dry.", "dune grass", "grass bundles", new String[0]);
        this.setEncumbrance(obj, Encumbrances.LIGHT_AND_LONG);
        this.addResourceCapability(obj, ResourceCapabilities.TINDER_MATERIAL);
        this.addResourceCapability(obj, ResourceCapabilities.WEAVABLE_MATERIAL);
        this.addResourceCapability(obj, ResourceCapabilities.COSMETIC_BINDING_MATEIRAL);
        return obj;
    }

    public Noun reeds() {
        SimpleNoun reeds = SimpleNoun.autoBuilder().setDescription("These reeds are wide and flexible.", "reed", "reeds", new String[0]).plural().build();
        NounMatchingSingularAndPlural obj = new NounMatchingSingularAndPlural(reeds);
        this.giveReedProperties(obj);
        return obj;
    }

    public Noun goldenReeds() {
        SimpleNoun reeds = SimpleNoun.autoBuilder().setDescription("These wide, flexible reeds have a shiny gold hue.", "golden reed", "reeds", new String[0]).plural().build();
        NounMatchingSingularAndPlural obj = new NounMatchingSingularAndPlural(reeds);
        this.giveReedProperties(obj);
        return obj;
    }

    private void giveReedProperties(Noun obj) {
        this.setEncumbrance(obj, Encumbrances.LIGHT_AND_LONG);
        this.addResourceCapability(obj, ResourceCapabilities.MINOR_ROOF_STRUCTURE);
        this.addResourceCapability(obj, ResourceCapabilities.COSMETIC_BINDING_MATEIRAL);
        this.addResourceCapability(obj, ResourceCapabilities.WEAVABLE_MATERIAL);
    }

    private static final class SpillContentsNotificationProvider
    implements PlayerNotificationProvider {
        private final Noun content;
        private final Noun oSpotToSpill;
        private final Preposition spillPreposition;

        private SpillContentsNotificationProvider(Noun content, Noun oSpotToSpill, Preposition spillPreposition) {
            this.content = content;
            this.oSpotToSpill = oSpotToSpill;
            this.spillPreposition = spillPreposition;
        }

        @Override
        public Sentences getMessage(Perceiver perceiver, PerceptionChannel channel, Frame frame) {
            NounPhrase contentDescription = this.content.getDefaultPerception(frame);
            String message = this.oSpotToSpill == null ? "The " + contentDescription + " spills." : "The " + contentDescription + " spills " + this.spillPreposition + " the " + this.oSpotToSpill.getDefaultPerception(frame) + ".";
            return Nlg.literalSentences(message);
        }
    }
}

