/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.structure;

import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.structure.PassageFilter;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import java.util.HashMap;
import java.util.Map;

public final class StructureStateBuilder
extends StructureState {
    public StructureStateBuilder() {
    }

    public StructureStateBuilder(StructureState structureState) {
        this.isIntegralMap.putAll(structureState.isIntegralMap);
        structureState.isSurroundingMap.forEach((noun, map) -> this.getOrCreateLocalMap((Noun)noun).putAll((Map<Preposition, Boolean>)map));
        this.passageFilterMap.putAll(structureState.passageFilterMap);
    }

    public StructureStateBuilder makeIntegral(Noun noun) {
        this.requireMutable();
        this.setIntegral(noun, true);
        return this;
    }

    public StructureStateBuilder setIntegral(Noun noun, boolean isIntegral) {
        this.requireMutable();
        this.isIntegralMap.put(noun, isIntegral);
        return this;
    }

    public StructureStateBuilder makeSurrounding(Noun noun, Preposition preposition) {
        this.setSurrounding(noun, preposition, true);
        return this;
    }

    public StructureStateBuilder setSurrounding(Noun noun, Preposition preposition, boolean value) {
        this.requireMutable();
        this.getOrCreateLocalMap(noun).put(preposition, value);
        return this;
    }

    public StructureStateBuilder setPassageFilter(Noun interfaceNoun, PassageFilter filter) {
        this.requireMutable();
        this.passageFilterMap.put(interfaceNoun, filter);
        return this;
    }

    private Map<Preposition, Boolean> getOrCreateLocalMap(Noun noun) {
        this.requireMutable();
        HashMap localMap = (HashMap)this.isSurroundingMap.get(noun);
        if (localMap == null) {
            localMap = new HashMap();
            this.isSurroundingMap.put(noun, localMap);
        }
        return localMap;
    }

    public StructureState build() {
        this.setImmutable();
        return this;
    }
}

