/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.structure;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import java.util.HashSet;
import java.util.Set;

public final class StructureAlgorithms {
    private StructureAlgorithms() {
    }

    public static Set<Noun> getNonintegralChildren(Noun noun, Frame frame) {
        HashSet<Noun> descendents = new HashSet<Noun>();
        StructureAlgorithms.accumulateNonintegralChildrenOf(noun, frame, descendents);
        return descendents;
    }

    private static void accumulateNonintegralChildrenOf(Noun noun, Frame frame, Set<Noun> descendents) {
        Set<Noun> childrenOfNoun = PositionState.get(frame).getChildren(noun);
        StructureState structure = StructureState.get(frame);
        if (childrenOfNoun == null) {
            return;
        }
        for (Noun child : childrenOfNoun) {
            if (structure.isIntegral(child)) {
                StructureAlgorithms.accumulateNonintegralDescendentsOf(child, frame, descendents);
                continue;
            }
            descendents.add(child);
        }
    }

    public static Set<Noun> getNonintegralDescendentsOf(Noun noun, Frame frame) {
        HashSet<Noun> descendents = new HashSet<Noun>();
        StructureAlgorithms.accumulateNonintegralDescendentsOf(noun, frame, descendents);
        return descendents;
    }

    private static void accumulateNonintegralDescendentsOf(Noun noun, Frame frame, Set<Noun> descendents) {
        Set<Noun> childrenOfNoun = PositionState.get(frame).getChildren(noun);
        StructureState structure = StructureState.get(frame);
        if (childrenOfNoun == null) {
            return;
        }
        for (Noun child : childrenOfNoun) {
            if (!structure.isIntegral(child)) {
                descendents.add(child);
            }
            StructureAlgorithms.accumulateNonintegralDescendentsOf(child, frame, descendents);
        }
    }
}

