/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states;

import com.fabriziopolo.textcraft.nlg.Conjunctions;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.IndependentClausesWithConjunction;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.ValueState;
import com.fabriziopolo.textcraft.states.capability.Capability;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractCapabilityState
extends ValueState<ArrayList<Capability>> {
    @Override
    protected ArrayList<Capability> combineValues(Noun noun, ArrayList<Capability> t1, ArrayList<Capability> t2, Simulation simulation) {
        ArrayList<Capability> allCapabilities = new ArrayList<Capability>();
        allCapabilities.addAll(t1);
        allCapabilities.addAll(t2);
        return allCapabilities;
    }

    @Override
    protected abstract Class getStateKey();

    @Override
    public abstract State updateState(Simulation var1);

    public boolean itemSatisfiesCapability(Noun item, Capability capability, Frame frame) {
        ArrayList itemCapabilities = (ArrayList)this.get(item);
        if (itemCapabilities == null) {
            return false;
        }
        for (Capability c : itemCapabilities) {
            if (!capability.isSatisfiedBy((Noun)item, (Capability)c, (Frame)frame).isSatisfied) continue;
            return true;
        }
        return false;
    }

    public Capability.Result getSatisfactionResult(Noun item, Capability capability, Frame frame) {
        if (item == null) {
            return Capability.Result.createFailure();
        }
        ArrayList itemCapabilities = (ArrayList)this.get(item);
        if (itemCapabilities == null) {
            return Capability.Result.createFailure();
        }
        IndependentClause reasonClause = null;
        for (Capability c : itemCapabilities) {
            Capability.Result result = capability.isSatisfiedBy(item, c, frame);
            if (result.isSatisfied) {
                return result;
            }
            if (result.failureReason == null) continue;
            if (reasonClause == null) {
                reasonClause = result.failureReason;
                continue;
            }
            reasonClause = IndependentClausesWithConjunction.create(reasonClause, Conjunctions.and, result.failureReason);
        }
        return Capability.Result.createFailure(reasonClause);
    }

    public List<Capability> getCapabilities(Noun noun) {
        ArrayList capabilities = (ArrayList)this.get(noun);
        if (capabilities == null) {
            return new ArrayList<Capability>();
        }
        return capabilities;
    }

    public List<Capability> getCapabilitiesSatisfying(Noun noun, Capability requirement, Frame frame) {
        return this.getCapabilities(noun).stream().filter(capability -> requirement.isSatisfiedBy((Noun)noun, (Capability)capability, (Frame)frame).isSatisfied).collect(Collectors.toList());
    }

    public void copyStateToBuilder(AbstractCapabilityState builder) {
        builder.requireMutable();
        this.getValueMap().forEach((noun, toolCapabilities) -> toolCapabilities.forEach(capability -> builder.addCapability((Noun)noun, (Capability)capability)));
    }

    public void addCapability(Noun noun, Capability capability) {
        this.requireMutable();
        this.getOrCreateCapabilityList(noun).add(capability);
    }

    private ArrayList<Capability> getOrCreateCapabilityList(Noun noun) {
        this.requireMutable();
        ArrayList list = (ArrayList)this.get(noun);
        if (list == null) {
            list = new ArrayList();
            this.set(noun, list);
        }
        return list;
    }
}

