/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.player;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.ValueProvider;
import com.fabriziopolo.textcraft.states.inventory.Inventory;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.textcraft.states.temperature.TemperatureState;
import java.util.Objects;

public class InventoryItemTemperatureProvider
implements ValueProvider<FlexibleHeatUnit, Void> {
    private final Noun player;

    public InventoryItemTemperatureProvider(Noun player) {
        this.player = Objects.requireNonNull(player);
    }

    @Override
    public FlexibleHeatUnit get(Noun noun, Void args, Frame frame) {
        TemperatureState temperatureState = TemperatureState.get(frame);
        Inventory inv = InventoryState.get(frame).get(this.player);
        if (inv == null) {
            return FlexibleHeatUnit.createNeutral();
        }
        FlexibleHeatUnit heat = FlexibleHeatUnit.createNeutral();
        for (Noun item : inv.getItems()) {
            FlexibleHeatUnit heatProducedBy = temperatureState.getHeatProducedBy(item, frame);
            if (heatProducedBy == null) continue;
            heat = heat.plus(heatProducedBy);
        }
        return heat;
    }
}

