/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.nlg;

import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.Number;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.objects.SimpleNoun;

public class SimpleNounAutoBuilder {
    private final SimpleNoun.Builder builder = SimpleNoun.builder();
    private boolean isVisibleInDarkEnforced = false;
    private boolean isDarkWhenBlindEnforced = false;
    private boolean isPluralEnforced = false;

    public SimpleNounAutoBuilder setDescription(String verboseDescription, String autoString, String pluralNounString, String ... alternatives) {
        this.builder.setDescription(Nlg.autoNounPhrase(autoString, pluralNounString, alternatives), Nlg.literalSentences(verboseDescription));
        return this;
    }

    public SimpleNounAutoBuilder setDescription(Sentences verboseDescription, NounPhrase description) {
        this.builder.setDescription(description, verboseDescription);
        return this;
    }

    public SimpleNounAutoBuilder setDarkDescription(String verboseDescription, String autoString, String pluralNounString, String ... alternatives) {
        this.builder.setDarkDescription(Nlg.autoNounPhrase(autoString, pluralNounString, alternatives), Nlg.literalSentences(verboseDescription));
        return this;
    }

    public SimpleNounAutoBuilder setDarkDescription(Sentences verboseDescription, NounPhrase description) {
        this.builder.setDarkDescription(description, verboseDescription);
        return this;
    }

    public SimpleNounAutoBuilder setBlindDescription(String verboseDescription, String autoString, String pluralNounString, String ... alternatives) {
        this.builder.setBlindDescription(Nlg.autoNounPhrase(autoString, pluralNounString, alternatives), Nlg.literalSentences(verboseDescription));
        return this;
    }

    public SimpleNounAutoBuilder visibleInDark() {
        this.isVisibleInDarkEnforced = true;
        return this;
    }

    public SimpleNounAutoBuilder darkWhenBlind() {
        this.isDarkWhenBlindEnforced = true;
        return this;
    }

    public SimpleNounAutoBuilder alwaysVisible() {
        this.visibleInDark();
        this.darkWhenBlind();
        return this;
    }

    public SimpleNounAutoBuilder plural() {
        this.isPluralEnforced = true;
        return this;
    }

    public SimpleNoun build() {
        if (this.isPluralEnforced) {
            NounPhrase blindDescription;
            NounPhrase darkDescription;
            NounPhrase description = this.builder.getNounPhraseDescription();
            if (description != null) {
                this.builder.setDescription(description.as(Number.Plural), this.builder.getVerboseDescription());
            }
            if ((darkDescription = this.builder.getNounPhraseDescriptionDark()) != null) {
                this.builder.setDarkDescription(darkDescription.as(Number.Plural), this.builder.getVerboseDescriptionDark());
            }
            if ((blindDescription = this.builder.getNounPhraseDescriptionBlind()) != null) {
                this.builder.setBlindDescription(blindDescription.as(Number.Plural), this.builder.getVerboseDescriptionBlind());
            }
        }
        if (this.isVisibleInDarkEnforced) {
            this.builder.setDarkDescription(this.builder.getNounPhraseDescription(), this.builder.getVerboseDescription());
        }
        if (this.isDarkWhenBlindEnforced) {
            this.builder.setBlindDescription(this.builder.getNounPhraseDescriptionDark(), this.builder.getVerboseDescriptionDark());
        }
        return this.builder.build();
    }
}

