/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textcraft.commands.AbstractCraftCommand;
import com.fabriziopolo.textcraft.commands.DefaultCraftingDelegateImpl;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.capability.Capability;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import java.util.List;

public abstract class InventoryItemCraftingDelegate
extends DefaultCraftingDelegateImpl {
    private static final String INVENTORY_ITEM_CRAFTING_VERB = "craft";

    protected InventoryItemCraftingDelegate(Noun prototype, List<Capability> resourceRequirements) {
        super(prototype, resourceRequirements, INVENTORY_ITEM_CRAFTING_VERB);
    }

    protected InventoryItemCraftingDelegate(Noun prototype, List<Capability> resourceRequirements, Capability toolRequirement) {
        super(prototype, resourceRequirements, toolRequirement, INVENTORY_ITEM_CRAFTING_VERB);
    }

    @Override
    public abstract Noun craftNewNoun(AbstractCraftCommand.ParseResult var1);

    @Override
    public void execute(AbstractCraftCommand.ParseResult result) {
        Noun craftedNoun = this.validateAndCraftNewNoun(result);
        if (craftedNoun == null) {
            return;
        }
        Simulation simulation = result.context.simulation;
        Player player = result.context.player;
        for (Noun resource : result.resources) {
            InventoryState.requestRemoveItem(player, resource, simulation);
        }
        InventoryState.requestAddItem(player, craftedNoun, simulation);
    }

    @Override
    public String getHint() {
        return null;
    }
}

