/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textcraft.commands.AbstractCraftCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import java.util.List;
import java.util.stream.Collectors;

public final class AggregateCraftCommand
implements Command {
    private final List<AbstractCraftCommand> craftCommands;

    public AggregateCraftCommand(List<AbstractCraftCommand> craftCommands) {
        if (craftCommands.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.craftCommands = craftCommands;
    }

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0 || !words[0].toLowerCase().equals(this.getCraftVerb())) {
            return null;
        }
        List resultsAndHintss = this.craftCommands.stream().map(command -> command.parse(words, context)).collect(Collectors.toList());
        ActionsAndHints aggreagte = new ActionsAndHints().addAll(resultsAndHintss);
        if (aggreagte.actions.isEmpty() && aggreagte.hints.isEmpty()) {
            return this.failToMatchObjectToCraft(words);
        }
        return aggreagte;
    }

    @Override
    public String getHelpString() {
        return this.craftCommands.get(0).getHelpString();
    }

    @Override
    public String getNameString() {
        return this.craftCommands.get(0).getNameString();
    }

    @Override
    public String getPurposeString() {
        return this.craftCommands.get(0).getPurposeString();
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private ActionsAndHints failToMatchObjectToCraft(String[] words) {
        if (words.length == 0) {
            return null;
        }
        if (words.length == 1) {
            return ActionsAndHints.hint(this.getHelpString());
        }
        String objectTypedByUserAutoNounString = "a";
        for (int idx = 1; idx < words.length && !words[idx].toLowerCase().equals("from"); ++idx) {
            objectTypedByUserAutoNounString = objectTypedByUserAutoNounString + " " + words[idx];
        }
        return ActionsAndHints.hint("You don't know how to " + this.getCraftVerb() + " " + NounPhraseWithArticle.a(Nlg.autoNounPhrase(objectTypedByUserAutoNounString)) + ".");
    }

    private String getCraftVerb() {
        return this.craftCommands.get(0).getCraftVerb();
    }
}

