/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app.menu;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.app.TextPrinter;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.peristence.Campaign;
import com.fabriziopolo.textcraft.simulation.Frame;
import java.util.function.Supplier;

public final class NewGameMenuOptionAction
implements UserAction {
    private final String description;
    private final Campaign campaignToSwitchTo;
    private final Supplier<SinglePlayerGameState> gameStateSupplier;

    public NewGameMenuOptionAction(Campaign campaignToSwitchTo, Supplier<SinglePlayerGameState> gameStateSupplier) {
        this("New Game", campaignToSwitchTo, gameStateSupplier);
    }

    public NewGameMenuOptionAction(String description, Campaign campaignToSwitchTo, Supplier<SinglePlayerGameState> gameStateSupplier) {
        this.description = description;
        this.campaignToSwitchTo = campaignToSwitchTo;
        this.gameStateSupplier = gameStateSupplier;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void execute(TextAppController controller) {
        TextPrinter txt = controller.getTxt();
        txt.println("Building world...");
        SinglePlayerGameState gameState = this.gameStateSupplier.get();
        txt.println();
        controller.setCampaign(this.campaignToSwitchTo);
        controller.setGameState(gameState);
    }

    @Override
    public boolean isValid(Frame frame) {
        return true;
    }
}

