module AR::Game::PlayerControl 

  def name
    "You"
  end

  def self.init ar_object 
    ar_object.ownership = "your"
  end

  def self.extended ar_object
    self.init ar_object
    ar_object.resolutions   << self.choose_action
    ar_object.subscriptions<< self.reprint_on_clock_tick(ar_object)
  end 

  def self.reprint_on_action_begun playr
    AR::Events::Subscription.new event_class: AR::Events::ActionBeganEvent do |e| 
      playr.printer.reprint_cache! if playr == e.performer
    end
  end


  def self.reprint_on_clock_tick playr
    AR::Events::Subscription.new event_class: AR::Events::ClockTickEvent do |e| 
      printer = playr.printer
      printer.reprint_cache! 
    end
  end


  def self.choose_action 
    AR::Events::Resolution.new event_class: AR::Events::ActorTurnEvent, as: "actor" do  |e|
      actor = e.actor
      results = []
        action = nil 
        while action.nil? and actor.action_points > 0
          action = actor.last_action  = actor.last_action_this_tick = AR::Game::ExplorationMenu.new(actor).present
        end
        unless action.nil?
          results.push(actor.create AR::Events::ActionBeganEvent, ({action: action}))
        else
          actor.last_action_this_tick = AR::Game::WaitAction.new actor
        end
      results
    end
  end
end
