class AR::Game::ARObject
  attr_accessor :id
  @@serialized_keys = {}

  def self.gen_id
    @@auto_incr_id ||= 0
    @@auto_incr_id += 1
  end

  def self.attr_serializeable *args, &block
    @@serialized_keys[self] ||= {}
    args.each do |arg|
      next unless @@serialized_keys[self][arg].nil?
      @@serialized_keys[self][arg] = {} 
      @@serialized_keys[self][arg][:serialize_proc] = block
      self.class_eval("def #{arg}=(val);@#{arg} = val; end")

      self.class_eval("def #{arg};@#{arg}; end")

    end
  end

  def self.attr_serializeable_gauge *args

    pr = Proc.new do |gauge, kase|
      case kase
      when :unload
        gauge.unload_data
      when :load
        g = AR::Gauge.new
        g.load_data gauge
      end
    end
    self.send("attr_serializeable", *args, &pr)
  end


  def self.serialized_attribute_tags
    @@serialized_keys[self].map{|elem| elem[:attr_tag]}
  end

  def self.unload_data_from instance
    ret = {}
    @@serialized_keys[self] ||= {}
    @@serialized_keys[self].each do |k, v|
      process = @@serialized_keys[self][k][:serialize_proc]
      unless process.nil? 
        ret[k] = process.call(instance.send(k), :unload, instance) 
      else
        ret[k] = instance.send(k)
      end
    end
    ret
  end

  def self.unload_data params
    instance = params[:_for] || params[:ar_object]
    unload_data_from instance
  end

  def self.load_data params
    instance = params[:_for] || params[:ar_object]
    #data should == ret from unload_data
    data = params[:data]
    data.each do |serialized_key,v|
      process = @@serialized_keys[self][serialized_key.to_sym][:serialize_proc]
      if process.nil?
        instance.send("#{serialized_key}=", v)
      else
        v = process.call(v, :load, instance)
        instance.send("#{serialized_key}=",v) 
      end
    end
  end

  def unload_data
    self.class.unload_data _for: self
  end

  def load_data d
    self.class.load_data _for: self, data: d
  end

  def initialize id = nil
    extend AR::Game::Behavior 
    @id = id || AR::Game::ARObject.gen_id
  end 

end



#order matters here....
#i.e. scenes and characters are types of physical objects
require_relative "ar_object/physical_object"
require_relative "ar_object/world"
require_relative "ar_object/scene"
require_relative "ar_object/character"
require_relative "ar_object/beast"
require_relative "ar_object/npc"

require_relative "ar_object/door"
require_relative "ar_object/fireplace"
require_relative "ar_object/your_house"
require_relative "ar_object/beetle_trophy"
require_relative "ar_object/player"
require_relative "ar_object/scene2"


require_relative "ar_object/clearing"
require_relative "ar_object/horse"
require_relative "ar_object/window"
require_relative "ar_object/forest"
require_relative "ar_object/trees"
require_relative "ar_object/branches"

require_relative "ar_object/shadows"
require_relative "ar_object/path"
require_relative "ar_object/inn"

require_relative "ar_object/guard_pike"


require_relative "ar_object/siasl_world"


require_relative "ar_object/item"
require_relative "ar_object/sword"

require_relative "ar_object/guard"

require_relative "ar_object/printer"


require_relative "ar_object/gauge"
