require "./lib/apocrodentia"
require "test/unit"
require_relative "../classes.rb"

class TestItemBehavior < BaseBehaviorTestCase 

  def setup
    @subject = SomeItem.new
    @inventory_owner = Traveller.new
    @scene  = GameScene.new
    @test_serialized_data = {owner_id: 666}
  end


  def test_owner_set_and_parent_unset_on_added_to_inventory
    @subject.parent = @scene
    e = AR::Events::ItemAddedToInventory.new item: @subject, inventory_owner: @inventory_owner
    @subject.on_resolved e, "item"
    assert_equal nil, @subject.parent_id
    assert_equal @subject.owner_id, @inventory_owner.id
  end
  

  def test_owner_unset_and_parent_set_on_removed_from_inventory
    @inventory_owner.parent = @scene
    @subject.owner = @inventory_owner
    @subject.parent = nil 
    e = AR::Events::ItemRemovedFromInventory.new item: @subject, inventory_owner: @inventory_owner
    @subject.on_resolved e, "item"
    assert_equal @subject.parent_id, @inventory_owner.parent_id
    assert_equal nil, @subject.owner_id
  end
  


end

