module AR
  module Game

    class Branches < Scene
      def initialize id = nil
        super 
        self.article = "the trees'"
        self.definite_article = "the trees'"
        self.noun = "branches"
        self.discovery_threshold = 2

#        self.discovered_story  = "The branches above reflect the dim, fluttering light from the distant clearing."
        
#        self.inspected_story =  "For the first time since you entered this wood, you can see animals peering down at you from the branches, eyes golden and hungry.  Have they been following you? Involentarily, you shiver."

        self.add_story_implement DiscoveredImplement.new
        self.add_story_implement InspectedImplement.new
      end

      class BranchesImplement < AR::Game::StoryBehavior::StoryImplement
      end

      class BranchesStory < AR::Game::StoryBehavior::Story
      end


      class DiscoveredImplement < BranchesImplement
        def initialize stories = []
          super
          s = BranchesStory.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "The branches above reflect the dim, fluttering light from the distant clearing."
            else 
              ret = ""
            end
            
            ret 
          end
          add_story s 
        end
      end


      class InspectedImplement < BranchesImplement 
        def initialize stories = []
          super
          s =  BranchesStory.new when: AR::Events::DiscoverableInspectedEvent, as: "inspected" do |e|
            if e.inspector == e.engine.world.player
              ret = "For the first time since you entered this wood, you can see animals peering down at you from the branches, eyes golden and hungry.  Have they been following you? Involentarily, you shiver."
            else 
              ret = ""
            end
            ret 
          end
          add_story s
        end
      end



    end


  end
end
