require_relative "../classes.rb"

class TestRestStation < BaseBehaviorTestCase

  def setup
    super

    @subject = Bed.new
    @rester = Traveller.new
    test_init_gauges
  end

  def test_rest_restores_hp_and_increases_hunger_by_2x_restored_hp
    g = @rester.gauge("health")
    assert_equal g.modified_current, g.modified_max 
    g.change_current -6
    assert_equal (g.modified_max - 6), g.modified_current

    e = AR::Events::CharacterSlept.new rester: @rester, station: @subject
    results = e.resolve!

    health_change = results.select{|r| r.class == AR::Events::GaugeChanged and r.gauge == g}.last
    hunger_change = results.select{|r| r.class == AR::Events::GaugeChanged and r.gauge == @rester.gauge("hunger")}.last

    assert_equal 6, health_change.amount
    assert_equal 12, hunger_change.amount
  end


end

