module AR::Game::Strength 
  EXP_THRESHOLDS = [3, 10, 20, 47, 76, 90, 125, 175, 225]
  
  #add attr_accessor properties here... 
  #if you don't need them serialized on save

  def strength_lvl
    gauge("strength").modified_current
  end

  def supposed_strength_lvl
    currently = strength_lvl
    lvl = currently
    EXP_THRESHOLDS.each_with_index do |threshold, i|
      lvl = i+1
      if strength_exp >= threshold
        next
      else
        break
      end
    end
    lvl
  end


  def self.add_strength_exp_on_hit_with_weapon
    AR::Events::Resolution.new event_class: AR::Events::HitSuccess, as: "hitter" do |e|
      c = e.hitter
      wep = c.equipped_on(:main_hand)
      if wep.nil? or !wep.class.to_s.include? "Dagger"
        c.strength_exp += 3
        AR.log("#{c.tag} is gaining 3 exp point in strength, supposed lvl: #{c.supposed_strength_lvl}")
      end
      
      nil
    end
  end


  def self.add_strength_exp_on_block_with_shield
    AR::Events::Resolution.new event_class: AR::Events::ActionPerformedEvent, as: "performer" do |e|
      c = e.performer
      a = e.action
      if a.class==AR::Game::DefendAction
        tech = a.parameter("technique").argument
        if tech.class == AR::Game::BlockTech
          c.strength_exp += 1
          AR.log("#{c.tag} is gaining 1 exp point in strength from blocking, supposed lvl: #{c.supposed_strength_lvl}")
        end
      end
      nil
    end
  end



  def self.gain_strength_lvl_on_slept
    AR::Events::Resolution.new event_class: AR::Events::CharacterSlept, as: "rester" do |e|
      c = e.rester
      currently = c.strength_lvl
      supposed = c.supposed_strength_lvl
      delta = supposed - currently
      if delta > 0
        AR::Events::ExpLevelGained.new leveler: c, gauge: c.gauge("strength"), amount: delta
      end
    end
  end



  #...initialize them here
  def self.init ar_object 
    ar_object.register_gauge "strength"
    ar_object.register_gauge "melee_dmg_bonus"

    ar_object.after_gauges_init do |obj|
      str = obj.gauge("strength")
      health = obj.gauge("health")
      m_d_b = obj.gauge("melee_dmg_bonus")
      str.parents! health, with: AR::Game::GaugeBehavior::LinearGaugeRelation, data: {factor: 2} unless health.nil?
      str.parents! m_d_b, with: AR::Game::GaugeBehavior::LinearGaugeRelation, data: {factor: 0.5} unless m_d_b.nil?
      str.change_current_and_max 1
      str.manual_child_sync
    end
 
    #add attr_serializeable properties here... 
    #if you do need them serialized on save
    ar_object.class.attr_serializeable :strength_exp
    ar_object.strength_exp = 0

  end

  def self.extended ar_object
    self.init ar_object
    ar_object.resolutions << add_strength_exp_on_hit_with_weapon
    ar_object.resolutions << gain_strength_lvl_on_slept
    ar_object.resolutions << add_strength_exp_on_block_with_shield
    #add to object's event subscriptions and resolutions here...
  end 

end
