module AR
  module Game

    #stands for Skull Medallion
    class SMWorld < World
      def initialize id=nil
        super 

        instantiate_game_objects do |world|
        
          #scenes 
          #(you start in forest01)
          forest01 = Forest01.new "forest01"
          forest02 = Forest02.new "forest02"
          forest03 = Forest03.new "forest03"
          forest04 = Forest04.new "forest04"
          forest05 = Forest05.new "forest05"
          forest06 = Forest06.new "forest06"

          hidden_forest01 = HiddenForest01.new "hidden_forest01"
          hidden_forest02 = HiddenForest02.new "hidden_forest02"

          old_man_courtyard = OldManCourtyard.new "old_man_courtyard"
          old_man_house = OldManHouse.new "old_man_house"

          cave01 = Cave01.new "cave01"
          cave02 = Cave02.new "cave02"
          cave03 = Cave03.new "cave03"
          cave04 = Cave04.new "cave04"

          hidden_cave01 = HiddenCave01.new "hidden_cave01"
          hidden_cave02 = HiddenCave02.new "hidden_cave02"








          
          #gateways
          #forest gateways
          f01_pn = Forest01PathNorth.new "f01pn"
          f01_pn.destination = forest02
          f01_hps = Forest01HiddenPathSouth.new "f01hps"
          f01_hps.destination = hidden_forest01 
          forest01.add_inhabitant f01_pn, "leading north"
          forest01.add_inhabitant f01_hps, "leading south"

          f02_pn = Forest02PathNorth.new "f02pn"
          f02_pn.destination = forest03
          f02_ps = Forest02PathSouth.new "f02ps"
          f02_ps.destination = forest01
          forest02.add_inhabitant f02_pn, "leading north"
          forest02.add_inhabitant f02_ps, "leading south"

          f03_pn = Forest03PathNorth.new "f03pn"
          f03_pn.destination = forest04
          f03_ps = Forest03PathSouth.new "f03ps"
          f03_ps.destination = forest02
          f03_ee = Forest03EntranceEast.new "f03ee"
          f03_ee.destination = cave01
          forest03.add_inhabitant f03_pn, "leading north"
          forest03.add_inhabitant f03_ps, "leading south"
          forest03.add_inhabitant f03_ee, "entering east"

          f04_pn = Forest04PathNorth.new "f04pn"
          f04_pn.destination = forest06
          f04_ps = Forest04PathSouth.new "f04ps"
          f04_ps.destination = forest03
          f04_pe = Forest04PathEast.new "f04pe"
          f04_pe.destination = forest05
          forest04.add_inhabitant f04_pn, "leading north"
          forest04.add_inhabitant f04_ps, "leading south"
          forest04.add_inhabitant f04_pe, "leading east"


          f05_pw = Forest05PathWest.new "f05pw"
          f05_pw.destination = forest04
          f05_ge = Forest05GateToCourtyard.new "gate_to_courtyard"
          f05_ge.destination = old_man_courtyard

          forest05.add_inhabitant f05_pw, "leading west"
          forest05.add_inhabitant f05_ge, "leading into a courtyard"


          f06_ps = Forest06PathSouth.new "f05ps"
          f06_ps.destination = forest04
          f06_hpn = Forest06HiddenPathNorth.new "f05hpn"
          f06_hpn.destination = hidden_forest02 
          forest06.add_inhabitant f06_ps, "leading south"
          forest06.add_inhabitant f06_hpn, "leading north"


          hf01_pn = HiddenForest01PathNorth.new "hf01_pn"
          hf01_pn.destination = forest01
          hidden_forest01.add_inhabitant hf01_pn, "leading north"


          hf02_ps = HiddenForest02PathSouth.new "hf02_ps"
          hf02_ps.destination = forest06
          hidden_forest02.add_inhabitant hf02_ps, "leading south"


          #old man scenes
          omc_gtf = OldManCourtyardGateToForest.new "old_man_courtyard_gate_to_forest"
          omc_di = OldManCourtyardDoorInside.new "old_man_courtyard_door_inside"
          old_man_courtyard.add_inhabitant omc_gtf, "leading to the forest"
          old_man_courtyard.add_inhabitant omc_di, "leading into the old man's home"

          omc_gtf.destination = forest05
          omc_di.destination = old_man_house 

          omh_do = OldManHouseDoorOutside.new "old_man_house_door_outside"
          old_man_house.add_inhabitant omh_do, "door leading outside"
          omh_do.destination = old_man_courtyard

          #cavern gateways
          c01_ew = Cave01ExitWest.new "c01_ew"
          c01_pe = Cave01PassageEast.new "c01_pe"
          c01_ew.destination = forest03 
          c01_pe.destination = cave02 
          cave01.add_inhabitant c01_ew, "leading out of the caverns"
          cave01.add_inhabitant c01_pe, "leading deeper into the caverns"
          

          c02_pw = Cave02PassageWest.new "c02_ew"
          c02_pe = Cave02PassageEast.new "c02_pe"
          c02_hps = Cave02HiddenPassageSouth.new "c02_hps"
          c02_pw.destination = cave01
          c02_pe.destination = cave03
          c02_hps.destination = hidden_cave01
          cave02.add_inhabitant c02_pw, "leading toward the light of the entrance"
          cave02.add_inhabitant c02_pe, "leading deeper into the caverns"
          cave02.add_inhabitant c02_hps, "hidden behind a boulder"
 
          c03_pe = Cave03PassageEast.new "c03_pe"
          c03_pe.destination = cave04
          c03_pw = Cave03PassageWest.new "c03_ew"
          c03_pw.destination = cave02
          cave03.add_inhabitant c03_pw, "leading toward the light of the entrance"
          cave03.add_inhabitant c03_pe, "leading deeper into the caverns"
  
          c04_pw = Cave04PassageWest.new "c04_pw"
          c04_pw.destination = cave03
          c04_hpe = Cave03PassageWest.new "c04_hpe"
          c04_hpe.destination = hidden_cave02
          cave04.add_inhabitant c04_pw, "leading toward the light of the entrance"
          cave04.add_inhabitant c04_hpe, "leading even deeper into the caverns"
         

          hc01_pn = HiddenCave01PassageNorth.new "hc01_pn"
          hc01_pn.destination = cave02
          hidden_cave01.add_inhabitant hc01_pn, "leading north"

          hc02_pw = HiddenCave02PassageWest.new "hc02_pw"
          hc02_pw.destination = cave04
          hidden_cave02.add_inhabitant hc02_pw, "leading west"


          #doodads
          moldy_log = MoldyLog.new "moldy_log"
          torch = Torch.new "torch"
          bed = Bed.new "bed"

          poisoned_shroom = PoisonousRedShroom.new 

          p = Player.new "player"

          #characters
          old_man = OldMan.new "old_man"
          beetle = GiantBeetle.new "beetle"
          cave_spider = CaveSpider.new "cave_spider"


          #add stuff to scenes scene
          old_man_house.add_inhabitant bed, "by a little round window on the west wall"

          forest01.add_inhabitant beetle, "in the brush"
          forest01.add_inhabitant p, "in the brush"
          forest01.add_inhabitant moldy_log, "in some mulch"
          forest01.add_inhabitant poisoned_shroom, "by a tree"

          forest02.add_inhabitant cave_spider, "in the bushes"

          #beetle death triggers old man entrance.
          s = AR::Events::Resolution.new event_class: AR::Events::ARObjectDied, as: "ar_object" do |e|
            obj = e.ar_object
            results = []
            ev1 = AR::Events::DiscoveryMadeEvent.new dont_narrate: true, perceiver: obj.world.player, discovered: obj.world.find("old_man")
            ev2 = AR::Events::DialogBeganEvent.new player: obj.world.player, npc: obj.world.find("old_man")
            results.push(ev1)
            results.push(ev2)

            results
          end
          #temporarily removing this....
          beetle.resolutions.push(s)



          e = AR::Events::NarrationEvent.new narration: "", new_paragraph: true
          e_l = AR::Events::NarrationEvent.new narration: "", new_paragraph: true
          e1 = AR::Events::DiscoveryMadeEvent.new perceiver: p,      discovered: beetle, dont_narrate: true 
          e3 = AR::Events::DiscoveryMadeEvent.new perceiver: p,      discovered: forest01, dont_narrate: true 
          e2 = AR::Events::DiscoveryMadeEvent.new perceiver: beetle, discovered: p 

          world.new_game_event = AR::Events::NarrationEvent.new(narration: "Everything is black. There is a slight friction sound, like canvas rubbing against itself.  A narrow crack of light begins to slice the dark in half near a revealing horizon. You are opening your eyes and realize you are lying on your back looking at a canopy of tree branches.  The friction noise crystalizes into ravenous chewing; you recognize the sound: Meat being torn from bone.  You turn your head toward the chewing.  Before you lies the corpse of a bat the size of a pony, being eaten by a carrion beetle the size of a wolf.  The huge insect is cleaning up the bat corpse, chunk by chunk...")

          eng  = world.events_engine
          eng.after_step e3
          eng.after_step e2
          eng.after_step e1
          eng.after_step e
          
        end 
 
      end
    end

  end#Game
end#AR
