module AR
  module Game

    class OldManHouseDoorOutside < PhysicalObject 
      def initialize id=nil
        super 
        self.noun = "door leading out into the courtyard"
        add_behavior Gateway
        add_story_implement StoryImplement.new
        #add_behavior AR::Game::SomeBehavior
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...

      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "#{e.discoverable.name.capitalize} makes you feel safe inside the old man's home."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "The wooden door leading out is quite sturdy looking; it actually looks like one solid piece of lumber."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

        end
      end


    end



  end
end

