require "./lib/apocrodentia"
require "test/unit"
require_relative "../classes.rb"

class TestInventoryBehavior < BaseBehaviorTestCase 

  def setup
    @subject = Traveller.new
    @subject2 = Traveller.new
    @item = SomeItem.new
    #this should get set to some serialized data representing loading/unloading
    @test_serialized_data = {inventory_item_ids: [1,2,3,4]}
  end

  def test_item_added_to_inventory_on_event
    e = AR::Events::ItemAddedToInventory.new item: @item, inventory_owner: @subject
    @subject.on_resolved e, "inventory_owner"
    assert @subject.inventory_item_ids.include?(@item.id)
  end

  def test_item_removed_to_inventory_on_event
    @subject.inventory_item_ids.push @item.id
    e = AR::Events::ItemRemovedFromInventory.new item: @item, inventory_owner: @subject
    @subject.on_resolved e, "inventory_owner"
    assert_empty @subject.inventory_item_ids
  end

  def test_item_removed_from_inventory_and_added_on_given_event
    @subject.inventory_item_ids.push @item.id
    e = AR::Events::ItemGivenEvent.new item: @item, giver: @subject, receiver: @subject2
    results = e.resolve!
    e1 = results.first
    e2 = results.last
    assert_equal AR::Events::ItemRemovedFromInventory, e1.class 
    assert_equal AR::Events::ItemAddedToInventory, e2.class 
    assert_equal @subject, e1.inventory_owner
    assert_equal @subject2, e2.inventory_owner
    assert_equal @item, e1.item
    assert_equal @item, e2.item
  end
  


end

