module AR
  module Game

    class GreenMushroom < Item
      def initialize id=nil
        super 
        #add_behavior AR::Game::SomeBehavior
        self.noun = "green mushroom"
        add_story_implement StoryImplement.new
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super
          #add stories like this:
          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "#{e.discovered.placement.capitalize}, you notice a patch of green mushrooms.  One looks particularly big."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            ret = "The cap is more narrow than the red variety.  It goes from a mellow green at the edge,  to a deep, forest green toward the tip."
          end
          add_story story

          story =  Story.new when: AR::Events::ItemAddedToInventory, as: "item" do |e|
            ret = "It feel cool and wet to the touch."
            if e.inventory_owner == e.engine.world.player
              ret
            end
          end
          add_story story




        end
      end

    end



  end
end
