package mechanique;

 

/*    
    
    MechaniQue, the programming language for Interactive Fiction
    Copyright (C) 2007  G.J.G.T. (Gabor) de Mooij

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (highest version applies !!).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
    ---MECHANIQUESOFT/GABOR DE MOOIJ

*/

 
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.applet.*;
import java.io.Serializable;
import java.lang.Math;
;

public class Story implements Serializable,StoryInterface, StoryController
{
    private StoryLineInterface currentStoryLine;    
    private int currentLineNumber;
    private KeyWalletInterface wallet = new KeyWallet(this);
    private SystemKeyGeneratorInterface generator = new SystemKeyGenerator(wallet);
    private Printable GUI;
    private ArrayList<StoryLineInterface> storyLines = new ArrayList<StoryLineInterface>();
    private HashMap<String,Integer> labelCatalogue = new HashMap<String,Integer>(); 
    private Stack<Integer> jumps = new Stack<Integer>();
    private Parser parserUnit = new Parser();
    private boolean abort = false;
    private boolean debugFlag = false;
    public boolean interact = false;
    public Receiver lastrc;
    
    public void setDebugFlag(boolean b)
    {
        this.debugFlag = b;
    }
    
    public boolean getDebugFlag()
    {
        return this.debugFlag;
    }
    
    public void stopStory()
    {
        this.abort = true;
    }
    
    public void setDisplayUnit(Printable GUI)
    {
        this.GUI = GUI;
        this.GUI.setStory(this);
        this.generator.init();
    }
    
    public void doStep()
    {
        while ((this.currentLineNumber < this.storyLines.size()) && !this.abort && !this.interact){
           this.getNextStoryLine();
           this.currentStoryLine.run();
           this.currentLineNumber += 1; 
           
        }
        if (this.currentLineNumber >= this.storyLines.size() || this.abort)
        {
            this.GUI.print("--End of program.-- Bye!");
        }
    
    }
    
    public void run(boolean b)
    {
        if (!b) this.currentLineNumber=0;
        this.doStep();
    }
    
    public void add(StoryLineInterface line)
    {
        line.setStory(this);
        this.storyLines.add(line);
    }
    
    public KeyWalletInterface getWallet()
    {
        return this.wallet;
    }
    
    public Printable getDisplayUnit()
    {
        return this.GUI;
    }
    
    private void getNextStoryLine()
    {
        this.currentStoryLine = this.storyLines.get(this.currentLineNumber);
    }
    
    public void setDestination(String label, boolean noStack)
    {
        if (!noStack) this.jumps.push(this.currentLineNumber);
        
        this.currentLineNumber = (int) this.labelCatalogue.get(label);
        this.currentLineNumber--;
    }
  
    public void jumpBack()
    {
        this.currentLineNumber = this.jumps.pop();
    }
    
    public SystemKeyGeneratorInterface getSystemKeyGenerator()
    {
        return this.generator;
    }
    
    public void setLabel(String s, Integer i)
    {
        this.labelCatalogue.put(s,i);
    }

    public int getLineNo ()
    {
    	return this.currentLineNumber;
    }
    
    public Parser getParser()
    {
        return this.parserUnit;
    }
    
    public void setParser(Parser p)
    {
        this.parserUnit = p;
    }
    
}
