package mechanique;

 

/*    
    
    MechaniQue, the programming language for Interactive Fiction
    Copyright (C) 2007  G.J.G.T. (Gabor) de Mooij

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (highest version applies !!).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
    ---MECHANIQUESOFT/GABOR DE MOOIJ

*/

 
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.applet.*;
import java.io.Serializable;
import java.lang.Math;
;

public class ActionFactory
{

	private Commandline cl;
	public ActionFactory(Commandline displayUnit)
	{
		cl = displayUnit;
	}
	
    public Executable make(String s){
        
        Executable product;
         
        if (s.indexOf("^#")==0)
        {
            product = new Comment();
            
        } else if (s.indexOf("^:")==0) {
            
            product = new ActionSay();
            product.setParameter(s.substring(2));
            
        } else if (s.indexOf("^?")==0) {
            
            product = new ActionAsk();
            
        } else if (s.indexOf("^+")==0) {
        
            product = new ActionAddKey();
            product.setParameter(s.substring(2).replaceAll(" ",""));
        
        } else if (s.indexOf("^->")==0) {
            
            product = new ActionGoto();
            product.setParameter(s.substring(3).replaceAll(" ",""));
            
            
        } else if (s.indexOf("^-")==0) {
            
            
            product = new ActionDropKey();
            product.setParameter(s.substring(2).replaceAll(" ",""));
            
        } else if (s.indexOf("^<-")==0) {
        
            product = new ActionReturn();
        
    	} else if (s.indexOf("^&")==0) {
        
    		product = new ActionPinPoint();
    
        } else {
        
            cl.print("could not parse action: "+s);
            System.exit(0);
            product = new Comment();
            
        }
        
        return product;
    }
}
