/*
 * Decompiled with CFR 0.152.
 */
package jurt;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import jurt.Action;
import jurt.Article;
import jurt.Command;
import jurt.Concept;
import jurt.Expression;
import jurt.IO;
import jurt.Nomen;
import jurt.Refusal;
import jurt.Scope;
import jurt.ScopeMethod;

public class Factor
implements Scope,
Serializable {
    int ct;
    int rank;
    boolean accept;
    Vector vector;
    Command command;
    int artmark;
    int bodymark;
    int endmark;
    Article article;
    boolean everything;
    int quantity;

    public Factor(Scope scope, Hashtable hashtable, Command command) throws Refusal {
        this.command = command;
        if (!command.hasMoreWords()) {
            throw new Refusal();
        }
        this.artmark = command.getMark();
        this.vector = new Vector();
        if (hashtable != null) {
            try {
                String string = command.parsePronoun();
                if (hashtable.containsKey(string)) {
                    this.vector.addElement((Concept)hashtable.get(string));
                    this.endmark = command.getMark();
                    this.quantity = 1;
                    return;
                }
            }
            catch (Refusal refusal) {
                // empty catch block
            }
            command.setMark(this.artmark);
        }
        try {
            this.article = new Article(command);
            this.bodymark = command.getMark();
        }
        catch (Refusal refusal) {
            this.article = null;
            this.bodymark = this.artmark;
        }
        try {
            scope.scopeLoop(new ScopeMethod(){

                public void scopeMethod(Concept concept) {
                    concept.identify(Factor.this);
                }
            });
        }
        catch (Refusal refusal) {
            // empty catch block
        }
        if (this.vector.isEmpty()) {
            command.setMark(this.artmark);
            try {
                command.parseSentenceSep();
            }
            catch (Refusal refusal) {
                command.error(this.artmark, "You don't see that here.");
            }
            throw new Refusal();
        }
        this.endmark = this.bodymark + this.ct;
        command.setMark(this.endmark);
        this.quantity = -1;
        if (!this.accept && this.article != null) {
            this.quantity = this.article.getQuantity();
        }
        if (this.quantity == -1) {
            int n = this.bodymark;
            if (this.accept) {
                n = this.artmark;
            }
            while (n < this.endmark && !Concept.isPlural(command.getWordAt(n))) {
                ++n;
            }
            this.quantity = 1;
            if (n < this.endmark) {
                this.quantity = Integer.MAX_VALUE;
            }
        }
    }

    public Factor(Scope scope) {
        this.vector = new Vector();
        this.quantity = Integer.MAX_VALUE;
        this.everything = true;
        try {
            scope.scopeLoop(new ScopeMethod(){

                public void scopeMethod(Concept concept) {
                    concept.identifyEvery(Factor.this);
                }
            });
        }
        catch (Refusal refusal) {
            // empty catch block
        }
    }

    public Concept toSingle(IO iO) throws Refusal {
        if (this.vector.isEmpty()) {
            throw new Refusal("But that reduces to nothing!");
        }
        if (this.quantity != 1) {
            throw new Refusal("You can only use one item in that context.");
        }
        Expression expression = this.disambiguate(iO);
        if (expression == null) {
            return (Concept)this.vector.firstElement();
        }
        return expression.toSingle(iO);
    }

    public boolean toMulti(IO iO, Vector vector) throws Refusal {
        int n = 0;
        while (n < this.vector.size()) {
            if (vector.contains(this.vector.elementAt(n))) {
                this.vector.removeElementAt(n);
                continue;
            }
            ++n;
        }
        boolean bl = true;
        if (this.quantity == 1) {
            bl = false;
            Expression expression = this.disambiguate(iO);
            if (expression != null) {
                return expression.toMulti(iO, vector);
            }
        }
        this.quantity = Math.min(this.quantity, this.vector.size());
        int n2 = 0;
        while (n2 < this.quantity) {
            vector.addElement(this.vector.elementAt(n2));
            ++n2;
        }
        return bl;
    }

    public Expression disambiguate(IO iO) throws Refusal {
        Object object;
        StringBuffer stringBuffer = null;
        Nomen nomen = null;
        int n = 0;
        while (n < this.vector.size()) {
            int n2 = Concept.collectSpecies(this.vector, n);
            if (nomen != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(nomen);
            }
            object = (Concept)this.vector.elementAt(n);
            nomen = n2 == 1 ? ((Concept)object).def() : ((Concept)object).indef();
            n += n2;
        }
        if (stringBuffer == null) {
            return null;
        }
        stringBuffer.append(" or ");
        stringBuffer.append(nomen);
        iO.println("Which one: " + stringBuffer + "?");
        iO.print("?");
        iO.flush();
        String string = iO.readLine();
        if (string == null) {
            throw new Refusal("[ No input read ]");
        }
        object = new Command(string);
        Expression expression = null;
        try {
            expression = new Expression(this.vector, (Command)object);
            if (((Command)object).hasMoreWords()) {
                throw new Refusal();
            }
        }
        catch (Refusal refusal) {
            throw new Refusal("Can you rephrase, being more specific?");
        }
        return expression;
    }

    public void exclude(Expression expression) {
        int n = this.quantity;
        int n2 = 0;
        while (n > 0 && n2 < this.vector.size()) {
            Concept concept = (Concept)this.vector.elementAt(n2);
            int n3 = 0;
            while (concept != this.vector.elementAt(n3)) {
                ++n3;
            }
            if (n3 == n2 && expression.excludeSingle(concept)) {
                --n;
            }
            ++n2;
        }
    }

    public boolean excludeSingle(Concept concept) {
        boolean bl = false;
        int n = 0;
        while (n < this.vector.size()) {
            if (concept == this.vector.elementAt(n)) {
                this.vector.removeElementAt(n);
                bl = true;
                continue;
            }
            ++n;
        }
        return bl;
    }

    public void scopeLoop(ScopeMethod scopeMethod) throws Refusal {
        int n = 0;
        while (n < this.vector.size()) {
            Concept concept = (Concept)this.vector.elementAt(n);
            scopeMethod.scopeMethod(concept);
            ++n;
        }
    }

    public void qualify(Action action) {
        action.qualifyVector(this.vector, this.everything);
    }

    public String getArticle() {
        if (this.article == null) {
            return null;
        }
        return this.article.getString();
    }

    public void resetBody() {
        this.command.setMark(this.bodymark);
    }

    public boolean hasMoreWords() {
        return this.command.hasMoreWords();
    }

    public String getNextWord() {
        return this.command.getNextWord();
    }

    public void nominate(Concept concept) {
        this.vector.addElement(concept);
    }

    public void nominate(Concept concept, boolean bl, int n, int n2) {
        if (n == 0 && !bl) {
            return;
        }
        if (n == this.ct && bl == this.accept && n2 == this.rank) {
            this.vector.addElement(concept);
        } else if (n > this.ct || n == this.ct && bl && !this.accept || n == this.ct && bl == this.accept && n2 > this.rank) {
            this.ct = n;
            this.accept = bl;
            this.rank = n2;
            this.vector.removeAllElements();
            this.vector.addElement(concept);
        }
    }

    public String toString() {
        return this.vector.toString();
    }
}

