## gosher -- A simple Gopher server in a POSIX shell script


`gosher` is a Gopher server in a POSIX shell script. It requires only a
standard `netcat(1)`. 

You start the server using:

    $ ./gosher [<PORT> [<GOPHERDIR>]

If PORT is not specified, it will bind on port 70. If GOPHERDIR is not
provided, it defaults to "./". Before starting `gosher` you might need
to modify the values of the variables `NETCAT` and `STYLE` in `gosher`
(see "Which netcat?" below).

If the selector is a directory, `gosher` will look for a file named
`gophermap` to render the submenu. If a `gophermap` does not exist,
`gosher` looks for the index.gph gopherfile in the folder and, if it
exists, renders it as a gophermap. If the required selector has a '.gph'
extension, `gosher` will treat it as a gopherpile, and render it as a
gophermap.


## Which netcat?

There are currently several different implementations of `netcat(1)`,
and each of them works in a slightly different way and/or offers a
different set of options. For the sake of using `gosher`, the main issue
is whether your `netcat(1)` implementation does exit or not when its
standard input gets closed.  Notably, the original `netcat(1)`
implementation by hobbit@avian.org does **not** exit, while other common
implementations (OpenBSD `netcat(1)`, `ncat(1)` from the nmap project,
and GNU `netcat(1)`) normally do.  The current version of `gosher` can
work with different implementations of `netcat(1)`, provided that the
variable `NETCAT` points to the `netcat(1)` version you want to use, and
that the variable `STYLE` in `gosher` is set correctly. In particular,
`STYLE` can pe set equal to either 'pipe' or 'fork'. Please check below
what is the recommended combination for your version of `netcat(1)`:

	+----------------+--------------+--------------+
	| netcat version | STYLE='fork' | STYLE='pipe' |
	+----------------+--------------+--------------+
	|  traditional   |      YES     |      NO      |
	+----------------+--------------+--------------+
	|  OpenBSD       |      NO      |      YES     |
	+----------------+--------------+--------------+
	|  ncat          |      YES     |      YES     |
	+----------------+--------------+--------------+

**N.B.: Using STYLE='pipe' is preferable, since the '-c' option used by
the 'fork' mode is a potential security risk**


## Running `gosher` under `chroot(8)`

In general, it makes sense to run a server in a `chroot(8)` environment, to
reduce the risks connected with remote exploits. If you would like to
run `gosher` under `chroot(8)` be sure to have the following binaries (and
the corresponding libs) available in the chroot-ed environment:

```
	basename(1) cat(1) cut(1) dirname(1) mkfifo(1) netcat(1) realpath(1)
	rm(1) sed(1) sh(1) which(1)
```

Obviously, `netcat(1)` will be your preferred `netcat(1)` implementation. 


## Why `gosher`?

Just for fun. There are only a few TCP/IP application protocols left
that can be implemented in a few dozen lines of POSIX shell script, and
Gopher (RFC 1436) is one of those. 

## Why calling it `gosher`?

Well, `gosher` is just `gopher` where the `p` is replaced with an `s`,
and `sh(1)` is all that you need to run `gosher` (if we leave
`netcat(1)` out...).

Also, `gopher` is probably one of the few `kosher` protocols out there.

According to the Urban Dictionary, `gosher` is "an insult that can mean
anything", so choose your own.
