#ifndef STEGOME_H
#define STEGOME_H

#include <u.h>
#include <libc.h>
#include <bio.h>

/* Constants */
#define BUFSIZE (8*1024*1024)  /* 8MB buffer size */
#define MAXPATH 1024

/* Steg methods */
enum {
    STEG_LSB = 0,  /* Least significant bit */
    STEG_BLEND = 1  /* Blend/alpha channel hiding */
};

/* Supported image formats */
enum {
    FMT_BIT = 0,  /* Plan 9 bit format */
    FMT_JPG = 1,  /* JPEG format */
    FMT_PNG = 2   /* PNG format */
};

/* Function prototypes */
void usage(void);
int hide_data(char *carrierfile, char *secretfile, char *outputfile, int method);
int extract_data(char *carrierfile, char *outputfile, int method);
int hide_lsb(uchar *imgbuf, ulong imgsize, uchar *data, long datalen, uchar **outbuf, ulong *outsize);
int extract_lsb(uchar *imgbuf, ulong imgsize, uchar *outbuf, long *outlen);
int hide_blend(uchar *imgbuf, ulong imgsize, uchar *data, long datalen, uchar **outbuf, ulong *outsize);
int extract_blend(uchar *imgbuf, ulong imgsize, uchar *outbuf, long *outlen);
int detect_format(char *filename);
int read_image(char *filename, uchar **buf, ulong *size);
int write_image(char *filename, uchar *buf, ulong size, int fmt);

#endif /* STEGOME_H */ 