#import "ObjCConstruct.h"

@class ObjCIdentifier, ObjCType;
@class NSMutableArray, NSMutableString;
@class NSString, NSArray;

@interface ObjCMethodDeclaration : ObjCConstruct
{
    BOOL isClassMethod;
    ObjCType *returnType;
    NSMutableArray *argumentTypes;
    NSMutableArray *arguments;
    NSMutableArray *methodParts;
    NSMutableString *_name;
}

- (NSString *)methodName;
- (ObjCType *)returnType;
- (NSArray *)arguments;
- (NSArray *)argumentTypes;
- (NSArray *)methodParts;
- (BOOL)isClassMethod;

- (void)setIsClassMethod:(BOOL)yn;
- (void)removeMethodPartAtIndex:(unsigned int)index;
- (void)addMethodPart:(ObjCIdentifier *)part withArgumentName:(ObjCIdentifier *)name 
	andType:(ObjCType *)type;
- (void)insertMethodPart:(ObjCIdentifier *)part withArgumentName:(ObjCIdentifier *)name 
	andType:(ObjCType *)type atIndex:(unsigned int)index;
- (void)_nameChanged;

@end
