#import <Foundation/NSObject.h>

@class NSArray, NSMutableArray, NSSet, NSMutableSet;

@interface ObjCFile : NSObject
{
    NSString *filename;
    NSMutableArray *contents;
    NSMutableSet *_classDefinitions, *_protocolDefinitions, *_typeDefinitions;
    NSMutableArray *_importedFiles;
}

- initWithFilename:(NSString *)aFile;

- (NSString *)filename;
- (NSArray *)contents;

- (void)setFilename:(NSString *)aName;
- (void)setContents:(NSMutableArray *)contents;
- (void)removeLineAtIndex:(unsigned int)index;

- (void)save;

- (NSSet *)typeDefinitions;
- (NSSet *)classDefinitions;
- (NSSet *)protocolDefinitions;
- (NSSet *)classDeclarations;
- (NSArray *)importedFiles;

- (NSSet *)neededTypeDeclarations;
- (NSSet *)neededClassDefinitions;
- (NSSet *)neededProtocolDefinitions;

@end
