#import "ObjCInterface.h"

@class NSMutableArray;
@class ObjCIdentifier;
@class NSString;
@class NSScanner;
@class NSMutableString;
@class NSArray;
@class ObjCIvarDeclaration;

@interface ObjCClassInterface : ObjCInterface
{
    NSMutableArray *nameContent, *beforeIvars, *ivars;
    ObjCIdentifier *_className, *_superClassName;
}

- initWithClassName:(NSString *)className superClass:(NSString *)superName;

- (void)_startScan:(NSScanner *)scanner;
- (NSMutableString *)_startText;
- (NSMutableString *)_ivarText;

- (NSString *)className;
- (NSString *)superClassName;
- (NSArray *)ivarDeclarations;
- (NSMutableArray *)nameContent;
- (NSMutableArray *)beforeIvarContent;

- (void)setClassName:(NSString *)name;
- (void)setSuperClassName:(NSString *)name;
- (void)addIvarDeclaration:(ObjCIvarDeclaration *)declaration;

@end
