// Copyright 1998 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/./Applications/OmniWeb/Source/OWAPI.h,v 3.1 1999/01/13 05:27:29 bungi Exp $


#ifndef __OWAPI_INCLUDED__
#define __OWAPI_INCLUDED__

@class NSString, NSArray, NSData;

// Each OmniWeb that is running will register a distributed object with
// the following format.  The '%@' will be replaced by the name of the
// user.  The '%d' will be replaced with a series of consecutive integers
// starting from zero.  Note that a user may start two copies of OmniWeb
// and then quit the first, leaving only instance '1' registered.
// For most applications, only instance zero will be of interest.  This
// registration scheme may change in the future to provide something a
// bit more robust and simple.
#define OW_ROOT_OBJECT_NAME_FORMAT  @"OmniWeb_%@_%d"

@protocol OWBrowser
// Closes the browser.  Once this method has been sent, the object should be
// considered invalidated and only the -release method should be sent.
- (void) close;

// Displays the content specified the by the given URL string
- (void) showURLString: (bycopy NSString *) urlString;

// Returns the URL being displayed in the top frame of the receiver.
- (bycopy NSString *) currentURLString;

// Returns to the previously viewed page in the top frame.
- (void) goBack;

// Moves forward in the history for the top frame.  Essentially the opposite of -goBack.
- (void) goForth;

// Loads the user's home page in the top frame.
- (void) goHome;

// Reloads the content in the top frame
- (void) reload;

// Stops loading anything loading in the browser
- (void) stop;

@end

@protocol OWController
// Returns an array of all of the open browsers.  Subsequent calls to -createBrowser
// or -close on OWBrowser will not be reflected in this array since it is sent bycopy.
- (bycopy NSArray *) browsers;

// Creates and returns a new browser displaying the content specified by the given URL string.
- (id <OWBrowser>) createBrowserWithURLString: (NSString *) urlString;

// Returns the active browser
- (id <OWBrowser>) activeBrowser;

@end


// OWRoot provides a security layer above OWController.  The root object registered
// for each OmniWeb instance will conform to this protocol.  The caller must read
// the data at the path specified by -securityKeyPath and pass it to
// -controllerForSecurityKey: in order to gain access to the remote API of OmniWeb.
// The file will be readable only be the user that is running OmniWeb.  This means
// that as long as the OS filesystem is secure, only the correct user or the
// superuser will be able to access the app instance.
@protocol OWRoot
- (bycopy NSString *) securityKeyPath;
- (id <OWController>) controllerForSecurityKey: (bycopy NSData *) key;
@end


#endif // __OWAPI_INCLUDED__
