// Starting with Rhapsody RDR, Apple added PNG support to the AppKit.  This is fine and good except that they didn't rename all of they PNG symbols to have a NS_ prefix.  This means that you cannot link the default PNG library with your code w/o doing your own renaming.  They DID rename all of their Zlib symbols apparently, but we still don't want to prevent someone else from linking their own copy of Zlib.
//
// We still want to use our own PNG library to get incremental image loading (which Apple's API doesn't provide).
//
// This list of defines was produced with the command:
//
//  nm -g $OMNI_BUILDOUTPUT/Frameworks/OmniZlib/objects-optimized-debug/*.i386.o | egrep " [DTS] " | awk '{print $3}' | sed 's/^_//' | awk '{printf "#define %s\tomni_%s\n", $1, $1}'

#ifndef _ZLIB_RENAME
#define _ZLIB_RENAME

#define adler32 omni_adler32
#define compress        omni_compress
#define compress2       omni_compress2
#define crc32   omni_crc32
#define get_crc_table   omni_get_crc_table
#define deflate omni_deflate
#define deflateCopy     omni_deflateCopy
#define deflateEnd      omni_deflateEnd
#define deflateInit2_   omni_deflateInit2_
#define deflateInit_    omni_deflateInit_
#define deflateParams   omni_deflateParams
#define deflateReset    omni_deflateReset
#define deflateSetDictionary    omni_deflateSetDictionary
#define deflate_copyright       omni_deflate_copyright
#define gzclose omni_gzclose
#define gzdopen omni_gzdopen
#define gzeof   omni_gzeof
#define gzerror omni_gzerror
#define gzflush omni_gzflush
#define gzgetc  omni_gzgetc
#define gzgets  omni_gzgets
#define gzopen  omni_gzopen
#define gzprintf        omni_gzprintf
#define gzputc  omni_gzputc
#define gzputs  omni_gzputs
#define gzread  omni_gzread
#define gzrewind        omni_gzrewind
#define gzseek  omni_gzseek
#define gzsetparams     omni_gzsetparams
#define gztell  omni_gztell
#define gzwrite omni_gzwrite
#define inflate_blocks  omni_inflate_blocks
#define inflate_blocks_free     omni_inflate_blocks_free
#define inflate_blocks_new      omni_inflate_blocks_new
#define inflate_blocks_reset    omni_inflate_blocks_reset
#define inflate_blocks_sync_point       omni_inflate_blocks_sync_point
#define inflate_set_dictionary  omni_inflate_set_dictionary
#define inflate_codes   omni_inflate_codes
#define inflate_codes_free      omni_inflate_codes_free
#define inflate_codes_new       omni_inflate_codes_new
#define inflate_fast    omni_inflate_fast
#define inflate omni_inflate
#define inflateEnd      omni_inflateEnd
#define inflateInit2_   omni_inflateInit2_
#define inflateInit_    omni_inflateInit_
#define inflateReset    omni_inflateReset
#define inflateSetDictionary    omni_inflateSetDictionary
#define inflateSync     omni_inflateSync
#define inflateSyncPoint        omni_inflateSyncPoint
#define inflate_copyright       omni_inflate_copyright
#define inflate_trees_bits      omni_inflate_trees_bits
#define inflate_trees_dynamic   omni_inflate_trees_dynamic
#define inflate_trees_fixed     omni_inflate_trees_fixed
#define inflate_flush   omni_inflate_flush
#define inflate_mask    omni_inflate_mask
#define _dist_code      omni__dist_code
#define _length_code    omni__length_code
#define _tr_align       omni__tr_align
#define _tr_flush_block omni__tr_flush_block
#define _tr_init        omni__tr_init
#define _tr_stored_block        omni__tr_stored_block
#define _tr_tally       omni__tr_tally
#define uncompress      omni_uncompress
#define zError  omni_zError
#define z_errmsg        omni_z_errmsg
#define zcalloc omni_zcalloc
#define zcfree  omni_zcfree
#define zlibVersion     omni_zlibVersion

#endif // _ZLIB_RENAME
