// Starting with Rhapsody RDR, Apple added PNG support to the AppKit.  This is fine and good except that they didn't rename all of their PNG symbols to have a NS_ prefix.  This means that you cannot link the default PNG library with your code w/o doing your own renaming.
//
// We still want to use our own PNG library to get incremental image loading (which Apple's API doesn't provide).
//
// This list of defines was produced with the command:
//
// nm -g $OMNI_BUILDOUTPUT/Frameworks/OmniPNG/objects-optimized-debug/*.i386.o | egrep " [DTS] " | awk '{print $3}' | sed 's/^_//' | awk '{printf "#define %s\tomni_%s\n", $1, $1}'

#ifndef _PNG_RENAME
#define _PNG_RENAME

#define png_IDAT        omni_png_IDAT
#define png_IEND        omni_png_IEND
#define png_IHDR        omni_png_IHDR
#define png_PLTE        omni_png_PLTE
#define png_bKGD        omni_png_bKGD
#define png_cHRM        omni_png_cHRM
#define png_calculate_crc       omni_png_calculate_crc
#define png_check_sig   omni_png_check_sig
#define png_convert_to_rfc1123  omni_png_convert_to_rfc1123
#define png_create_info_struct  omni_png_create_info_struct
#define png_destroy_info_struct omni_png_destroy_info_struct
#define png_gAMA        omni_png_gAMA
#define png_get_io_ptr  omni_png_get_io_ptr
#define png_hIST        omni_png_hIST
#define png_info_destroy        omni_png_info_destroy
#define png_info_init   omni_png_info_init
#define png_init_io     omni_png_init_io
#define png_libpng_ver  omni_png_libpng_ver
#define png_oFFs        omni_png_oFFs
#define png_pCAL        omni_png_pCAL
#define png_pHYs        omni_png_pHYs
#define png_pass_dsp_mask       omni_png_pass_dsp_mask
#define png_pass_inc    omni_png_pass_inc
#define png_pass_mask   omni_png_pass_mask
#define png_pass_start  omni_png_pass_start
#define png_pass_yinc   omni_png_pass_yinc
#define png_pass_ystart omni_png_pass_ystart
#define png_reset_crc   omni_png_reset_crc
#define png_sBIT        omni_png_sBIT
#define png_sRGB        omni_png_sRGB
#define png_set_sig_bytes       omni_png_set_sig_bytes
#define png_sig omni_png_sig
#define png_sig_cmp     omni_png_sig_cmp
#define png_tEXt        omni_png_tEXt
#define png_tIME        omni_png_tIME
#define png_tRNS        omni_png_tRNS
#define png_zTXt        omni_png_zTXt
#define png_zalloc      omni_png_zalloc
#define png_zfree       omni_png_zfree
#define png_chunk_error omni_png_chunk_error
#define png_chunk_warning       omni_png_chunk_warning
#define png_error       omni_png_error
#define png_get_error_ptr       omni_png_get_error_ptr
#define png_set_error_fn        omni_png_set_error_fn
#define png_warning     omni_png_warning
#define png_get_IHDR    omni_png_get_IHDR
#define png_get_PLTE    omni_png_get_PLTE
#define png_get_bKGD    omni_png_get_bKGD
#define png_get_bit_depth       omni_png_get_bit_depth
#define png_get_cHRM    omni_png_get_cHRM
#define png_get_channels        omni_png_get_channels
#define png_get_color_type      omni_png_get_color_type
#define png_get_compression_type        omni_png_get_compression_type
#define png_get_filter_type     omni_png_get_filter_type
#define png_get_gAMA    omni_png_get_gAMA
#define png_get_hIST    omni_png_get_hIST
#define png_get_image_height    omni_png_get_image_height
#define png_get_image_width     omni_png_get_image_width
#define png_get_interlace_type  omni_png_get_interlace_type
#define png_get_oFFs    omni_png_get_oFFs
#define png_get_pCAL    omni_png_get_pCAL
#define png_get_pHYs    omni_png_get_pHYs
#define png_get_pixel_aspect_ratio      omni_png_get_pixel_aspect_ratio
#define png_get_pixels_per_meter        omni_png_get_pixels_per_meter
#define png_get_rowbytes        omni_png_get_rowbytes
#define png_get_sBIT    omni_png_get_sBIT
#define png_get_sRGB    omni_png_get_sRGB
#define png_get_signature       omni_png_get_signature
#define png_get_tIME    omni_png_get_tIME
#define png_get_tRNS    omni_png_get_tRNS
#define png_get_text    omni_png_get_text
#define png_get_valid   omni_png_get_valid
#define png_get_x_offset_microns        omni_png_get_x_offset_microns
#define png_get_x_offset_pixels omni_png_get_x_offset_pixels
#define png_get_x_pixels_per_meter      omni_png_get_x_pixels_per_meter
#define png_get_y_offset_microns        omni_png_get_y_offset_microns
#define png_get_y_offset_pixels omni_png_get_y_offset_pixels
#define png_get_y_pixels_per_meter      omni_png_get_y_pixels_per_meter
#define png_create_struct       omni_png_create_struct
#define png_destroy_struct      omni_png_destroy_struct
#define png_free        omni_png_free
#define png_malloc      omni_png_malloc
#define png_memcpy_check        omni_png_memcpy_check
#define png_memset_check        omni_png_memset_check
#define png_get_progressive_ptr omni_png_get_progressive_ptr
#define png_process_IDAT_data   omni_png_process_IDAT_data
#define png_process_data        omni_png_process_data
#define png_process_some_data   omni_png_process_some_data
#define png_progressive_combine_row     omni_png_progressive_combine_row
#define png_push_crc_finish     omni_png_push_crc_finish
#define png_push_crc_skip       omni_png_push_crc_skip
#define png_push_fill_buffer    omni_png_push_fill_buffer
#define png_push_handle_tEXt    omni_png_push_handle_tEXt
#define png_push_handle_unknown omni_png_push_handle_unknown
#define png_push_handle_zTXt    omni_png_push_handle_zTXt
#define png_push_have_end       omni_png_push_have_end
#define png_push_have_info      omni_png_push_have_info
#define png_push_have_row       omni_png_push_have_row
#define png_push_process_row    omni_png_push_process_row
#define png_push_read_IDAT      omni_png_push_read_IDAT
#define png_push_read_chunk     omni_png_push_read_chunk
#define png_push_read_sig       omni_png_push_read_sig
#define png_push_read_tEXt      omni_png_push_read_tEXt
#define png_push_read_zTXt      omni_png_push_read_zTXt
#define png_push_restore_buffer omni_png_push_restore_buffer
#define png_push_save_buffer    omni_png_push_save_buffer
#define png_read_push_finish_row        omni_png_read_push_finish_row
#define png_set_progressive_read_fn     omni_png_set_progressive_read_fn
#define png_create_read_struct  omni_png_create_read_struct
#define png_destroy_read_struct omni_png_destroy_read_struct
#define png_read_destroy        omni_png_read_destroy
#define png_read_end    omni_png_read_end
#define png_read_image  omni_png_read_image
#define png_read_info   omni_png_read_info
#define png_read_init   omni_png_read_init
#define png_read_row    omni_png_read_row
#define png_read_rows   omni_png_read_rows
#define png_read_update_info    omni_png_read_update_info
#define png_set_read_status_fn  omni_png_set_read_status_fn
#define png_start_read_image    omni_png_start_read_image
#define png_read_data   omni_png_read_data
#define png_set_read_fn omni_png_set_read_fn
#define png_build_gamma_table   omni_png_build_gamma_table
#define png_build_grayscale_palette     omni_png_build_grayscale_palette
#define png_do_background       omni_png_do_background
#define png_do_chop     omni_png_do_chop
#define png_do_dither   omni_png_do_dither
#define png_do_expand   omni_png_do_expand
#define png_do_expand_palette   omni_png_do_expand_palette
#define png_do_gamma    omni_png_do_gamma
#define png_do_gray_to_rgb      omni_png_do_gray_to_rgb
#define png_do_read_filler      omni_png_do_read_filler
#define png_do_read_invert_alpha        omni_png_do_read_invert_alpha
#define png_do_read_swap_alpha  omni_png_do_read_swap_alpha
#define png_do_read_transformations     omni_png_do_read_transformations
#define png_do_unpack   omni_png_do_unpack
#define png_do_unshift  omni_png_do_unshift
#define png_init_read_transformations   omni_png_init_read_transformations
#define png_read_transform_info omni_png_read_transform_info
#define png_set_background      omni_png_set_background
#define png_set_crc_action      omni_png_set_crc_action
#define png_set_dither  omni_png_set_dither
#define png_set_expand  omni_png_set_expand
#define png_set_gamma   omni_png_set_gamma
#define png_set_gray_to_rgb     omni_png_set_gray_to_rgb
#define png_set_read_user_transform_fn  omni_png_set_read_user_transform_fn
#define png_set_strip_16        omni_png_set_strip_16
#define png_set_strip_alpha     omni_png_set_strip_alpha
#define png_check_chunk_name    omni_png_check_chunk_name
#define png_combine_row omni_png_combine_row
#define png_crc_error   omni_png_crc_error
#define png_crc_finish  omni_png_crc_finish
#define png_crc_read    omni_png_crc_read
#define png_do_read_interlace   omni_png_do_read_interlace
#define png_get_int_32  omni_png_get_int_32
#define png_get_uint_16 omni_png_get_uint_16
#define png_get_uint_32 omni_png_get_uint_32
#define png_handle_IEND omni_png_handle_IEND
#define png_handle_IHDR omni_png_handle_IHDR
#define png_handle_PLTE omni_png_handle_PLTE
#define png_handle_bKGD omni_png_handle_bKGD
#define png_handle_cHRM omni_png_handle_cHRM
#define png_handle_gAMA omni_png_handle_gAMA
#define png_handle_hIST omni_png_handle_hIST
#define png_handle_oFFs omni_png_handle_oFFs
#define png_handle_pCAL omni_png_handle_pCAL
#define png_handle_pHYs omni_png_handle_pHYs
#define png_handle_sBIT omni_png_handle_sBIT
#define png_handle_sRGB omni_png_handle_sRGB
#define png_handle_tEXt omni_png_handle_tEXt
#define png_handle_tIME omni_png_handle_tIME
#define png_handle_tRNS omni_png_handle_tRNS
#define png_handle_unknown      omni_png_handle_unknown
#define png_handle_zTXt omni_png_handle_zTXt
#define png_read_filter_row     omni_png_read_filter_row
#define png_read_finish_row     omni_png_read_finish_row
#define png_read_start_row      omni_png_read_start_row
#define png_set_IHDR    omni_png_set_IHDR
#define png_set_PLTE    omni_png_set_PLTE
#define png_set_bKGD    omni_png_set_bKGD
#define png_set_cHRM    omni_png_set_cHRM
#define png_set_gAMA    omni_png_set_gAMA
#define png_set_hIST    omni_png_set_hIST
#define png_set_oFFs    omni_png_set_oFFs
#define png_set_pCAL    omni_png_set_pCAL
#define png_set_pHYs    omni_png_set_pHYs
#define png_set_sBIT    omni_png_set_sBIT
#define png_set_sRGB    omni_png_set_sRGB
#define png_set_sRGB_gAMA_and_cHRM      omni_png_set_sRGB_gAMA_and_cHRM
#define png_set_tIME    omni_png_set_tIME
#define png_set_tRNS    omni_png_set_tRNS
#define png_set_text    omni_png_set_text
#define png_do_bgr      omni_png_do_bgr
#define png_do_invert   omni_png_do_invert
#define png_do_packswap omni_png_do_packswap
#define png_do_strip_filler     omni_png_do_strip_filler
#define png_do_swap     omni_png_do_swap
#define png_set_bgr     omni_png_set_bgr
#define png_set_filler  omni_png_set_filler
#define png_set_interlace_handling      omni_png_set_interlace_handling
#define png_set_invert_alpha    omni_png_set_invert_alpha
#define png_set_invert_mono     omni_png_set_invert_mono
#define png_set_packing omni_png_set_packing
#define png_set_packswap        omni_png_set_packswap
#define png_set_shift   omni_png_set_shift
#define png_set_swap    omni_png_set_swap
#define png_set_swap_alpha      omni_png_set_swap_alpha
#define png_flush       omni_png_flush
#define png_set_write_fn        omni_png_set_write_fn
#define png_write_data  omni_png_write_data
#define png_convert_from_struct_tm      omni_png_convert_from_struct_tm
#define png_convert_from_time_t omni_png_convert_from_time_t
#define png_create_write_struct omni_png_create_write_struct
#define png_destroy_write_struct        omni_png_destroy_write_struct
#define png_set_compression_level       omni_png_set_compression_level
#define png_set_compression_mem_level   omni_png_set_compression_mem_level
#define png_set_compression_method      omni_png_set_compression_method
#define png_set_compression_strategy    omni_png_set_compression_strategy
#define png_set_compression_window_bits omni_png_set_compression_window_bits
#define png_set_filter  omni_png_set_filter
#define png_set_filter_heuristics       omni_png_set_filter_heuristics
#define png_set_flush   omni_png_set_flush
#define png_set_write_status_fn omni_png_set_write_status_fn
#define png_set_write_user_transform_fn omni_png_set_write_user_transform_fn
#define png_write_destroy       omni_png_write_destroy
#define png_write_end   omni_png_write_end
#define png_write_flush omni_png_write_flush
#define png_write_image omni_png_write_image
#define png_write_info  omni_png_write_info
#define png_write_init  omni_png_write_init
#define png_write_row   omni_png_write_row
#define png_write_rows  omni_png_write_rows
#define png_do_pack     omni_png_do_pack
#define png_do_shift    omni_png_do_shift
#define png_do_write_invert_alpha       omni_png_do_write_invert_alpha
#define png_do_write_swap_alpha omni_png_do_write_swap_alpha
#define png_do_write_transformations    omni_png_do_write_transformations
#define png_check_keyword       omni_png_check_keyword
#define png_do_write_interlace  omni_png_do_write_interlace
#define png_save_int_32 omni_png_save_int_32
#define png_save_uint_16        omni_png_save_uint_16
#define png_save_uint_32        omni_png_save_uint_32
#define png_write_IDAT  omni_png_write_IDAT
#define png_write_IEND  omni_png_write_IEND
#define png_write_IHDR  omni_png_write_IHDR
#define png_write_PLTE  omni_png_write_PLTE
#define png_write_bKGD  omni_png_write_bKGD
#define png_write_cHRM  omni_png_write_cHRM
#define png_write_chunk omni_png_write_chunk
#define png_write_chunk_data    omni_png_write_chunk_data
#define png_write_chunk_end     omni_png_write_chunk_end
#define png_write_chunk_start   omni_png_write_chunk_start
#define png_write_filtered_row  omni_png_write_filtered_row
#define png_write_find_filter   omni_png_write_find_filter
#define png_write_finish_row    omni_png_write_finish_row
#define png_write_gAMA  omni_png_write_gAMA
#define png_write_hIST  omni_png_write_hIST
#define png_write_oFFs  omni_png_write_oFFs
#define png_write_pCAL  omni_png_write_pCAL
#define png_write_pHYs  omni_png_write_pHYs
#define png_write_sBIT  omni_png_write_sBIT
#define png_write_sRGB  omni_png_write_sRGB
#define png_write_sig   omni_png_write_sig
#define png_write_start_row     omni_png_write_start_row
#define png_write_tEXt  omni_png_write_tEXt
#define png_write_tIME  omni_png_write_tIME
#define png_write_tRNS  omni_png_write_tRNS
#define png_write_zTXt  omni_png_write_zTXt

#endif // _PNG_RENAME
