// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniNetworking/ONSocketStream.h,v 1.10 1999/03/30 21:25:21 kc Exp $

#import <OmniBase/OBObject.h>

@class NSData;
@class NSMutableData;
@class NSString;
@class ONSocket;

#import <Foundation/NSString.h> // For NSStringEncoding

@interface ONSocketStream : OBObject
{
    ONSocket *socket;
    NSMutableData *readBuffer;
}

+ streamWithSocket:(ONSocket *)aSocket;
- initWithSocket:(ONSocket *)aSocket;
- (ONSocket *)socket;
- (BOOL)isReadable;

- (void)setReadBuffer:(NSMutableData *)aData;
- (void)clearReadBuffer;
- (void)advanceReadBufferBy:(unsigned int)advanceAmount;

- (NSData *)readData;
- (NSData *)readDataOfLength:(unsigned int)length;
- (NSData *)readDataWithMaxLength:(unsigned int)length;

- (NSString *)readString;
    // Note:  not currently reliable if the stringEncoding is set to a multibyte encoding

- (NSString *)readLineAndAdvance:(BOOL)shouldAdvance;
- (NSString *)readLine;
- (NSString *)peekLine;

- (void)writeString:(NSString *)aString;
- (void)writeFormat:(NSString *)aFormat, ...;
- (void)writeData:(NSData *)theData;

- (NSStringEncoding)stringEncoding;
- (void)setStringEncoding:(NSStringEncoding)aStringEncoding;

@end
