// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniNetworking/ONSocket.h,v 1.9 1999/03/30 21:25:21 kc Exp $

#import <OmniBase/OBObject.h>

@class NSData;
@class NSMutableData;

#import <Foundation/NSString.h> // for NSStringEncoding

@interface ONSocket : OBObject
{
    NSStringEncoding stringEncoding;
    unsigned int readBufferSize;
}

// These are the primitive methods which must be implemented by subclasses
- (unsigned int)readBytes:(unsigned int)byteCount intoBuffer:(void *)aBuffer;
- (unsigned int)writeBytes:(unsigned int)byteCount fromBuffer:(const void *)aBuffer;
- (void)abortSocket;

- (BOOL)isReadable;
- (BOOL)isWritable;

@end

@interface ONSocket (General)

// These methods operate in terms of the primitive methods, and therefore need not be implemented by subclasses.

+ (void)setDefaultStringEncoding:(NSStringEncoding)aStringEncoding;
+ (void)setDefaultReadBufferSize:(int)aSize;

- (void)writeData:(NSData *)data;
- (void)writeString:(NSString *)aString;
- (void)writeFormat:(NSString *)aFormat, ...;
- (void)readData:(NSMutableData *)data;
- (NSData *)readData;
- (NSString *)readString;

- (NSStringEncoding)stringEncoding;
- (void)setStringEncoding:(NSStringEncoding)aStringEncoding;
- (void)setReadBufferSize:(int)aSize;

@end
