// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniNetworking/ONHost.h,v 1.8 1999/03/30 21:25:18 kc Exp $

#import <OmniBase/OBObject.h>

@class NSArray, NSMutableArray;
@class ONHostAddress;

@interface ONHost : OBObject
{
    NSString *hostname;
    NSString *canonicalHostname;
    NSMutableArray *addresses;
}

+ (NSString *)domainName;
+ (NSString *)localHostname;

+ (ONHost *)hostForHostname:(NSString *)hostname;
+ (ONHost *)hostForAddress:(ONHostAddress *)anAddress;

- (NSString *)hostname;
- (NSArray *)addresses;
- (NSString *)canonicalHostname;
- (NSString *)domainName;

@end

#import "FrameworkDefines.h"

// Exceptions which may be raised by this class
OmniNetworking_EXTERN NSString *ONHostNotFoundExceptionName;
OmniNetworking_EXTERN NSString *ONHostNameLookupErrorExceptionName;
OmniNetworking_EXTERN NSString *ONHostHasNoAddressesExceptionName;
OmniNetworking_EXTERN NSString *ONGetHostByNameNotFoundExceptionName;
