// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Scripting.subproj/OWScriptContext.h,v 1.10 1999/06/19 00:50:34 kc Exp $

#import <OWF/OWF.h>
#import "OWScriptInterpreterProtocol.h"

@class OWScriptFrameProxy, OWScriptDocumentProxy;
@class OHHTMLDocument;

extern NSString *OWScriptContextInvalidationNotification;
extern BOOL OHScriptLanguageCaseInsensitive;

@interface OWScriptContext : OFObject
{
    OWContentInfo *ownerInfo;
    
    NSMutableArray *interpreters;
    
    OWScriptFrameProxy *frameProxy;
    BOOL frameProxyIsHint;
    BOOL invalid;
    BOOL hadError;

    OWAddress *baseAddress;
}

+ contextAssociatedWithFrame:(OWScriptFrameProxy *)aFrame;

- initWithOwner:(OWContentInfo *)newOwner;

- (void)setFrame:(OWScriptFrameProxy *)aFrame hint:(BOOL)justAHint;
- (OWScriptFrameProxy *)getFrameHint:(int *)isHint;

- (id <OWScriptInterpreter>)interpreterForLanguage:(NSString *)languageName;

// - (OWScriptFrameProxy *)frameProxy;
- (OWScriptDocumentProxy *)documentProxy;
- (OWContentInfo *)contentInfo;

/* for callbacks specified in HTML attributes. The second form is needed for form elements and links; see the comment in JSInterpreter.h */
- (void)setHandler:(OWScriptEventType)handlerName onObject:anObject toString:(NSString *)handlerCode;
- (void)setHandler:(OWScriptEventType)handlerName onObject:anObject parented:anotherObject toString:(NSString *)handlerCode;

- (void)invalidate;
- (BOOL)isValid;
- (BOOL)hadError;
- (void)setHadError;

- (OWAddress *)baseAddress;
- (void)setBaseAddress:(OWAddress *)newBaseAddress;

@end

