// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Support.subproj/OWAddress-OHPasteboard.h,v 1.2 1999/06/19 00:50:37 kc Exp $

#import <OWF/OWAddress.h>

@class NSPasteboard, NSImage;
@class OAPasteboardHelper;

@interface OWAddress (Pasteboard)

+ (NSArray *)recognizedPasteboardTypes;
+ (NSString *)OWNewWindowURIType;

+ (OWAddress *)addressFromPasteboard:(NSPasteboard *)pasteboard;

// These are convenience methods for classes that implement the OAOutlineDragSupport protocol.  These are never called directly by OAOutlineView, but lots of the classes it calls call some of these

+ (NSArray *)acceptedPasteboardTypes;
+ (id)entryFromPropertyList:(id)propertyList ofType:(NSString *)type;
+ (NSImage *)dragImageForEntry:anEntry;

+ (void)declareTypesForEntry:(id)anEntry pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;
+ (void)addTypesForEntry:(id)anEntry pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;
- (void)pasteboard:(NSPasteboard *)pasteboard provideDataForType:(NSString *)type;

- (void)copyToGeneralPasteboard;

@end
