// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Support.subproj/OWAddress-OHDragging.h,v 1.2 1999/06/19 00:50:36 kc Exp $

#import <OWF/OWAddress.h>

@class NSEvent, NSImage, NSView;
@class OAPasteboardHelper;
@class OIImage;

#import <Foundation/NSGeometry.h> // For NSPoint

@interface OWAddress (Dragging)

- (void)startDragFromView:(NSView *)view image:(NSImage *)image atPoint:(NSPoint)location event:(NSEvent *)event pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;
    // Drags an address.  Checks the event to see whether this is a normal URL drag, a drag to create a new window (alt-drag), or a drag to download (command-drag).

- (void)startDragFromView:(NSView *)view atPoint:(NSPoint)location event:(NSEvent *)event;
    // Calls -startDragFromView:image:atPoint:event:pasteboardHelper:, calculating the missing parameters.

- (void)startDragOmniImage:(OIImage *)omniImage imageAddress:(OWAddress *)imageAddress fromView:(NSView *)aView event:(NSEvent *)event;
    // Drags an image.


@end

