// Copyright 1998-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Support.subproj/OWAddress-OHActions.h,v 1.2 1999/06/19 00:50:36 kc Exp $

#import <OWF/OWAddress.h>

#import <Foundation/NSGeometry.h> // For NSPoint

@interface OWAddress (AppSupport)

- (void)addToBookmarks;
    // This method posts an OWAddressAddToBookmarksNotification to cause the address to be bookmarked.

- (void)openDocumentInNewWindow;
    // This method posts an OWAddressOpenInNewWindowNotification to cause the address to be opened in a new window.

- (void)openDocumentInNewWindowAtScreenPoint:(NSPoint)aPoint;
    // This method posts an OWAddressOpenInNewWindowNotification to cause the address to be opened in a new window at the specified screen point.

@end

#import "FrameworkDefines.h"

OmniHTML_EXTERN NSString *OWAddressAddToBookmarksNotification;
    // This notification is posted by the -addToBookmarks method to actually add the address to the user's bookmarks.

OmniHTML_EXTERN NSString *OWAddressOpenDocumentInNewWindowNotification;
    // This notification is posted by the -openDocumentInNewWindow and -openDocumentInNewWindowAtScreenPoint: methods.  The application should be listening for this notification, and open the window as requested.

OmniHTML_EXTERN NSString *OWAddressOpenDocumentInNewWindowScreenPointKey;
    // The new window's screen point is held in an NSValue under this key.  (If this key isn't present, no specific screen point was requested.)

