// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Cells.subproj/OHViewCell.h,v 1.7 1999/06/19 00:50:31 kc Exp $

#import "OHBasicCell.h"

@interface OHViewCell : OHBasicCell
{
    struct {
        unsigned int doNotRelayoutWhenContentViewFrameChanges:1;
    } viewCellFlags;
@private
    NSView *_contentView;
    NSSize _contentViewSize;
}

- (BOOL)hasContentView;
    // Returns whether the view cell currently has a content view.  Note that calling -contentView on a cell without a content view triggers an assertion if it can't create one.  (It will try to create one by calling -setupContentView.)

- (NSView *)contentView;
    // Returns the current content view.  NOTE:  Do NOT subclass this to return a different value, use -setContentView: instead.

- (void)setupContentView;
    // Subclass this method to set up the content view.

- (void)setContentView:(NSView *)newContentView;
    // Call this method from -setupContentView.

//

- (void)resetContentViewOrigin;
    // Called internally to position the content view

- (void)resetContentViewSize;
    // Called internally to size the content view

@end

@interface OHViewCell (NextKeyViewSupport)

- (void)_setNextKeyViewCell:(OHViewCell *)nextKeyViewCell;
    // Sets the nextKeyView on the contentView to the view of the nextKeyViewCell.

- (void)setNextKeyViewCell:(OHViewCell *)nextKeyViewCell;
    // subclasses implement if they want to be in the key view loop by calling [self _setNextKeyViewCell:nextKeyViewCell];
@end
