// Copyright 1997-1999 Omni Development, Inc.  All rights reserved.
//
// $Header: /Network/Source/CVS/OmniGroup/OmniHTML/Cells.subproj/OHInlineImageCell.h,v 1.9 1999/06/19 00:50:30 kc Exp $

#import "OHImageCell.h"

@class NSLock;
@class OFInvocation;
@class OWAddress, OHHTMLDocument, OHHTMLOwner, OHImageMapHolder, OWWebPipeline, OWScriptEventHandlerHolder;
@class OIImage;

#import <OWF/OWTargetProtocol.h>
#import <OIF/OIImageObserverProtocol.h>

@interface OHInlineImageCell : OHImageCell <OWTarget, OIImageObserver>
{
    OHHTMLDocument *nonretainedHTMLDocument;
    
    NSString *alternateText;
    NSFont *textFont;
    NSString *name;

    struct {
        unsigned int isMap:1;
    } inlineFlags;

    enum {
	OHInlineImageCell_rasa,
	OHInlineImageCell_fetching,
	OHInlineImageCell_aborting,
	OHInlineImageCell_fetched,
	OHInlineImageCell_aborted,
	OHInlineImageCell_failedToLoad,
    } inlineImageState;

    OIImage *omniImage;

    OHImageMapHolder *imageMapHolder;

    OWScriptEventHandlerHolder *eventHandlers;

    /* Note: This lock doesn't cover everything it probably should */
    NSLock *imageStateLock;
}

+ (OWAddress *)addressForPossiblyInternalIconString:(NSString *)iconKeyString;

- initWithAddress:(OWAddress *)anAddress referringAddress:(OWAddress *)aReferringAddress htmlDocument:(OHHTMLDocument *)htmlDocument;

//

- (OHHTMLDocument *)htmlDocument;

- (void)setLink:(OHHTMLAnchor *)aLink;
- (void)setAlternateText:(NSString *)newAlternateText inFont:(NSFont *)aFont;
- (void)setIsMap:(BOOL)newIsMap;
- (void)setMapAddress:(OWAddress *)anAddress;
- (void)setName:(NSString *)aName;

- (void)resetAddress:(OWAddress *)newAddress referrer:(OWAddress *)aReferringAddress;
- (OWAddress *)address;
- (NSString *)name;
- (BOOL)needsFetch;
- (BOOL)isFetching;
- (void)fetch;

- (void)startAnimation;
- (void)stopAnimation;

- (OWScriptEventHandlerHolder *)eventHandlers;

@end


@interface OHInlineImageCell (SubclassesOnly)
- (BOOL)clickActionForEvent:(NSEvent *)event inHTMLView:(OHHTMLView *)htmlView;
- (OWAddress *)addressForEvent:(NSEvent *)event inHTMLView:(OHHTMLView *)htmlView;
- (NSPoint)mapPointForEvent:(NSEvent *)event inHTMLView:(OHHTMLView *)htmlView;
@end
